package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.AddGoodsShoppingCartBO;
import cn.freemud.demo.entities.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.dto.goods.add.BaseAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.MCoffeeAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.PlatformAddGoodsVO;
import cn.freemud.demo.enums.BizTypeEnum;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class AddGoodsVOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public BaseAddGoodsVO convert2AddGoodsVO(String bizType, ShoppingCartGoodsBO baseAddGoodsBO) {
        BaseAddGoodsVO baseAddGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }


    private PlatformAddGoodsVO createPlatformVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        PlatformAddGoodsVO platformAddGoodsVO = mapperFacade.map(baseAddGoodsBO, PlatformAddGoodsVO.class);
        return platformAddGoodsVO;
    }

    private MCoffeeAddGoodsVO createMCoffeeVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        MCoffeeAddGoodsVO mCoffeeAddGoodsVO = new MCoffeeAddGoodsVO();
        return mCoffeeAddGoodsVO;
    }

}
