package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.GetActivityBO;
import cn.freemud.demo.entities.GetCalculationDiscountBO;
import cn.freemud.demo.entities.GetProductStock;
import cn.freemud.demo.entities.QueryActivityByTypeDTO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class PromotionBO2DTOAdapter {


    @Resource
    private MapperFacade mapperFacade;


    public CalculationSharingDiscountRequestDto convert2CalculationSharingDiscountRequestDto(GetCalculationDiscountBO getProductStock) {
        CalculationSharingDiscountRequestDto dto = mapperFacade.map(getProductStock, CalculationSharingDiscountRequestDto.class);
        return dto;
    }

    public QueryActivityByTypeDTO convert2QueryActivityByTypeDTO(GetActivityBO getActivityBO) {
        QueryActivityByTypeDTO dto = mapperFacade.map(getActivityBO, QueryActivityByTypeDTO.class);
        return dto;
    }

}
