package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.ValidateShopProductRequestBO;
import cn.freemud.demo.entities.GetProductStock;
import cn.freemud.demo.entities.ProductStockBO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductRequest;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ProductBO2DTOAdapter {

    @Resource
    private MapperFacade mapperFacade;


    public GetProductStockRequestDto convert2GetProductStockDto(GetProductStock getProductStock) {
        GetProductStockRequestDto getProductStockRequestDto = new GetProductStockRequestDto();
        getProductStockRequestDto.setChannel(getProductStock.getChannel());
        getProductStockRequestDto.setPartnerId(getProductStock.getPartnerId());
        getProductStockRequestDto.setProductIds(getProductStock.getProductIds());
        getProductStockRequestDto.setStoreId(getProductStock.getStoreId());

        return getProductStockRequestDto;
    }

    public ValidateShopProductRequest convert2ValidateShopProductRequest(ValidateShopProductRequestBO validateShopProductRequestBO) {

        ValidateShopProductRequest validateShopProductRequest = mapperFacade.map(validateShopProductRequestBO, ValidateShopProductRequest.class);

        return validateShopProductRequest;
    }


}
