package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.ReceiveAddressBO;
import cn.freemud.demo.entities.StoreInfoBO;
import cn.freemud.demo.entities.UserScoreUserDetailBO;
import cn.freemud.entities.dto.user.GetUserScoreUserDetailResponse;
import com.freemud.application.sdk.api.membercenter.response.QueryReceiveAddressResponse;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class CustomerDTO2BOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public ReceiveAddressBO convert2StoreInfoBO(QueryReceiveAddressResponse dto) {
        ReceiveAddressBO bo = mapperFacade.map(dto, ReceiveAddressBO.class);

        return bo;
    }

    public UserScoreUserDetailBO convert2UserScoreUserDetailBO(GetUserScoreUserDetailResponse dto) {
        UserScoreUserDetailBO bo = mapperFacade.map(dto, UserScoreUserDetailBO.class);
        return bo;
    }

}
