package cn.freemud.management.entities.dto.request.coupon;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CouponCodeVerificationReqVO
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: biao.zhang
 * @date: 2018/7/17 14:45
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class MCCafeCouponLockRequest {
    private Integer ver;

    /**
     *  71 核销
     *  89 锁定
     *  90 解锁
     */
    private Integer reqType;
    /**
     * 核销渠道
     * 1：线下Pos
     * 2：线上
     * 3：pickup：麦当劳点餐
     * 4：delivery：麦当劳外送
     * 5：mccafe：麦当劳咖啡
     * 6：mc_dessert麦当劳甜品站
     * 7：SOK
     * 8：ECP/CMA
     * 9：mcd_alipay：麦当劳支付宝点餐
     */
    private String channel;

    //商户编号
    private String partnerId;

    //商家门店号
    private String storeId;

    //营业员编号
    private String operatorId;

    //POS机编号
    private String stationId;

    //交易序号
    private String transId;

    //券编号
    private String coupon;

    //三方券号
    private String offerId;

    //锁定/解锁次数
    private String number;

    private String appFlag;

    private String businessDate;


    //----非必传---

    //预约订单时间,为空则为及时单，如：2020-06-17 12:00:00
    private String advancedOrderTime;

    //签名
    private String sign;

    private List<MCCafeTransactionVo> transactions;

}
