/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMenuCategoryVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/15 14:40
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
public class GetMenuCategoryVo {

    @NotEmpty(message = "partnerId 不能为空")
    private String partnerId;

    @NotEmpty(message = "门店编号不能为空")
    private String shopId;
    /**
     * 渠道 默认 beiguo
     */
    @NotEmpty(message = "渠道类型不能为空")
    private String channelType;
    /**
     *  菜单分类：1 分类 + 第一类商品，2 分类+全部商品概述，3 仅分类，4 分类+ 第一类商品分页显示， 默认1
     */
    @NotNull(message = "infoLevel不能为空")
    private Integer infoLevel;

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    // 订单类型 点餐方式
    private Integer orderType;

    private String version;

}
