package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

@Data
public class MenuModuleDto {
    /**
     * 是否启用（false：禁用，true：启用）
     */
    private Boolean enabledStatus;
    /**
     * 背景颜色
     */
    private String backgroundColor;

    /**
     * 模块高度
     */
    private String moduleHeight;
    /**
     * 排序
     */
    private Integer sequence;
    /**
     * 图片模块
     */
    private List<PictureList> pictureList;
    @Data
    public static class PictureList{
        /**
         * 菜单名称
         */
        private String menuName;
        /**
         * 默认图片地址
         */
        private String defaultPictureUrl;
        /**
         * 点击图片地址
         */
        private String checkPictureUrl;

        /**
         *绑定小程序appid以及跳转地址
         */
        private String bindAppPath;
        /**
         *绑定小程序appid
         */
        private String bindAppId;
    }
}
