/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CheckOrder
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: ping.wu
 * @date: 2019/5/8 10:01
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;

import cn.freemud.adapter.OrderAdapter;
import cn.freemud.base.util.DateUtil;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.StoreConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.order.BusinessDate;
import cn.freemud.entities.dto.shoppingCart.GetShoppingCartGoodsApportionDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.*;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.manager.StoreTableNumberManager;
import cn.freemud.service.CouponService;
import cn.freemud.service.adapter.OrderCheckAdapter;
import cn.freemud.service.order.OrderRelationFactory;
import cn.freemud.service.order.OrderRelationService;
import cn.freemud.service.thirdparty.ShoppingCartClient;
import cn.freemud.utils.LogUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformIappWxappConfig;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerStoreDeliveryConfig;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformIappWxappConfigManager;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformPartnerStoreDeliveryConfigManager;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.membercenter.request.QueryReceiveAddressRequest;
import com.freemud.application.sdk.api.membercenter.request.StatisticalPropertyRequest;
import com.freemud.application.sdk.api.membercenter.response.GetSvcInfoByMemberIdResponse;
import com.freemud.application.sdk.api.membercenter.response.QueryReceiveAddressResponse;
import com.freemud.application.sdk.api.membercenter.service.MemberCenterService;
import com.freemud.application.sdk.api.membercenter.service.MemberPropertyService;
import com.freemud.application.sdk.api.ordercenter.enums.PayChannelType;
import com.freemud.application.sdk.api.paymentcenter.client.request.SVCCardAmountRequest;
import com.freemud.application.sdk.api.paymentcenter.client.response.SVCCardAmountResponse;
import com.freemud.application.sdk.api.paymentcenter.client.service.PaymentNewService;
import com.freemud.application.sdk.api.storecenter.request.QueryDeliveryRequest;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.QueryDeliverDetailResponse;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import lombok.extern.log4j.Log4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.rmi.runtime.Log;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Component
@Log4j
public class CheckOrder {

    // 配送费逻辑是否使用旧的
    @Value("${store.delivery.use.old}")
    private boolean storeDeliveryUseOld;

    @Autowired
    private StoreTableNumberManager storeTableNumberManager;
    @Autowired
    private AssortmentOpenPlatformIappWxappConfigManager openPlatformIappWxappConfigManager;
    @Autowired
    private AssortmentOpenPlatformPartnerStoreDeliveryConfigManager deliveryConfigManager;
    // 缓存取用户数据用
//    @Autowired
//    private UserServiceImpl userService;
    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;
    //门店SDK
    @Autowired
    private StoreCenterService storeCenterService;
    //会员SDK
    @Autowired
    private MemberCenterService memberCenterService;
    //会员SDK
    @Autowired
    private MemberPropertyService memberPropertyService;
    @Autowired
    private ShoppingCartClient shoppingCartClient;
//    @Autowired
//    private OrderAdapter orderAdapter;
    @Autowired
    private StoreServiceImpl storeService;

    @Autowired
    private CouponService couponService;
    private static Gson gson = new Gson();
    @Autowired
    private PaymentNewService paymentNewService;

    @Autowired
    private OrderAdapter orderAdapter;

    @Autowired
    private OrderRelationFactory orderRelationFactory;

    /**
     * 下单会员相关校验
     */
    public AssortmentCustomerInfoVo checkOrderByMember(CreateOrderVo createOrderVo, String trackingNo) {
        // 通过sessionId查询缓存中会员id
        String sessionId = createOrderVo.getSessionId();
        AssortmentCustomerInfoVo userLoginInfoDto = customerInfoManager.getCustomerInfoByObject(sessionId);
        if (userLoginInfoDto == null || StringUtils.isEmpty(userLoginInfoDto.getMemberId())) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        //校验会员svc卡信息
        checkCardCode(createOrderVo.getPartnerId(), userLoginInfoDto.getMemberId(), createOrderVo.getCardCode());

        createOrderVo.setUserId(userLoginInfoDto.getMemberId());
        return userLoginInfoDto;
    }


    public AssortmentCustomerInfoVo checkOrderByMemberNew(String sessionId, String cardCode) {
        // 通过sessionId查询缓存中会员id
        AssortmentCustomerInfoVo userLoginInfoDto = customerInfoManager.getCustomerInfoByObject(sessionId);
        if (userLoginInfoDto == null || StringUtils.isEmpty(userLoginInfoDto.getMemberId())) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        //校验会员svc卡信息
        checkCardCode(userLoginInfoDto.getPartnerId(), userLoginInfoDto.getMemberId(), cardCode);
        return userLoginInfoDto;
    }

    public AssortmentCustomerInfoVo getMemberNew(String sessionId) {
        // 通过sessionId查询缓存中会员id
        AssortmentCustomerInfoVo userLoginInfoDto = customerInfoManager.getCustomerInfoByObject(sessionId);
        if (userLoginInfoDto == null || StringUtils.isEmpty(userLoginInfoDto.getMemberId())) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        return userLoginInfoDto;
    }

    /**
     * 查询门店信息
     */
    public StoreResponse getStoreInfo(String partnerId, String shopId, String trackingNo) {
        // 获取门店信息
        StoreInfoRequest storeInfoRequest = new StoreInfoRequest(partnerId, shopId, null);
        return storeCenterService.getStoreInfo(storeInfoRequest, trackingNo);
    }

    /**
     * 下单门店相关校验
     */
    public StoreResponse.BizVO checkOrderByStore(CreateOrderVo createOrderVo, String trackingNo) {
        String partnerId = createOrderVo.getPartnerId();
        String shopId = createOrderVo.getShopId();

        // 获取门店信息
        StoreResponse storeResponse = getStoreInfo(partnerId, shopId, trackingNo);
        if (storeResponse == null || storeResponse.getBizVO() == null) {
            throw new ServiceException(ResponseResult.STORE_NOT_FOUND);
        }
        //订单预约单检查
        OrderCheckAdapter.check(createOrderVo, storeResponse);

        StoreResponse.BizVO storeResponseDto = storeResponse.getBizVO();
        // 校验门店是否停业 1 营业 2 停业 3 繁忙置休
        if (storeResponseDto.getActiveFlag() == null || storeResponseDto.getActiveFlag() != 1) {
            throw new ServiceException(ResponseResult.STORE_ITEM_STOP_BUSINESS);
        }
        createOrderVo.setStoreName(storeResponseDto.getStoreName());
        createOrderVo.setStoreAddress(storeResponseDto.getAddress());
        createOrderVo.setThirdShopId(storeResponseDto.getThirdPartCode());
        return storeResponseDto;
    }

    /**
     * 下单订单类型校验
     */
    public Integer checkOrderByOrderType(CreateOrderVo createOrderVo, AssortmentCustomerInfoVo userLoginInfoDto,
                                         StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto, String trackingNo) {

        // 下单时间校验
        OrderRelationService orderRelationService = orderRelationFactory.getCreateOrderTimeCheckService(createOrderVo.getPartnerId());
        orderRelationService.createOrderTimeCheck(storeResponseDto, createOrderVo);

        Integer pushOrderTime = 0;
        //非到店或者外卖，类型错误
        if (!(CreateOrderType.COLLECT_GOODS.getCode().equals(createOrderVo.getOrderType()) ||
                CreateOrderType.TAKE_OUT.getCode().equals(createOrderVo.getOrderType()))) {
            throw new ServiceException(ResponseResult.PARAMETER_MISSING);
        }
        // TODO: 2020/6/16 门店校验处理
        String takeMealFlag = createOrderVo.getTakeMealFlag();
        String takeMealTimes = createOrderVo.getTakeMealTime();

        //立即送达
        if ("0".equals(takeMealFlag) || (StringUtils.isEmpty(createOrderVo.getExpectTime()) && StringUtils.isEmpty(takeMealTimes))) {
            //未营业无预约时间无法下单
            if (!StoreConstant.BUSINESS.equals(storeResponseDto.getState())) {
                throw new ServiceException(ResponseResult.STORE_ITEM_CHECK_CLOSE);
            }
            // 外卖单选择立即送达的话，下单时间必须在店铺外卖时间内
            if (createOrderVo.getOrderType().compareTo(CreateOrderType.TAKE_OUT.getCode()) == 0) {
                checkTakeOutTime(storeResponseDto, new Date(), new Date(), true);
            }
        }

        //有预约时间
        if (StringUtils.isNotBlank(takeMealTimes) || StringUtils.isNotBlank(createOrderVo.getExpectTime())) {
            // 设置预约时间
            Date takeMealDateTime = getOrderExpectTime(takeMealFlag, takeMealTimes, createOrderVo.getExpectTime(),
                    CreateOrderType.getByCode(createOrderVo.getOrderType()), storeResponseDto.getServiceTime(), storeResponseDto);
            if (takeMealDateTime != null) {
                //校验预约时间
                checkOrderExpectTime(createOrderVo, storeResponseDto, takeMealDateTime);
                //重新赋值为yyyy-MM-dd HH:mm:ss格式字符串时间
                createOrderVo.setExpectTime(DateUtil.convert2String(takeMealDateTime, "yyyy-MM-dd HH:mm:ss"));
            }
        }
        String appId = userLoginInfoDto.getWxAppId();
        // 校验小程序是否支持到店或者外卖
        AssortmentOpenPlatformIappWxappConfig config = openPlatformIappWxappConfigManager.selectIappWxappConfigByWxAppId(appId);
        // 自提校验
        if (CreateOrderType.COLLECT_GOODS.getCode().equals(createOrderVo.getOrderType())) {
            if (config == null || config.getTakeInside() == null || config.getTakeInside() != 1) {
                throw new ServiceException(ResponseResult.ORDER_WXAPP_NOT_ENABLE_COLLECT_GOODS);
            }
            if (storeResponseDto.getIsSelfMention() == null || storeResponseDto.getIsSelfMention() != 1) {
                throw new ServiceException(ResponseResult.STORE_NOT_ENABLE_COLLECT_GOODS);
            }
            createOrderVo.setUserName(userLoginInfoDto.getNickName());
            createOrderVo.setMobile(userLoginInfoDto.getMobile());
        }
        // 校验外卖信息
        if (CreateOrderType.TAKE_OUT.getCode().equals(createOrderVo.getOrderType())) {
            if (config == null || config.getTakeaway() == null || config.getTakeaway() == 0) {
                throw new ServiceException(ResponseResult.STORE_ITEM_NOT_DELIVERY);
            }
            if (storeResponseDto.getDelivery() == null || storeResponseDto.getDelivery() == 2) {
                throw new ServiceException(ResponseResult.STORE_ITEM_NOT_DELIVERY);
            }
            if (StringUtils.isBlank(storeResponseDto.getDeliveryHoursDay())) {
                throw new ServiceException(ResponseResult.STORE_ITEM_NOT_DELIVERY);
            }
            //获取门店配送信息
            StoreDeliveryInfoDto storeDeliveryInfoDto = null;
            if (storeDeliveryUseOld) {
                storeDeliveryInfoDto = getStoreDeliveryInfo(storeResponseDto, config, appId);
            } else {
                storeDeliveryInfoDto = getNewStoreDeliveryInfo(storeResponseDto, config, appId, trackingNo);
            }
            //todo : 这里不再支持从表中获取门店配送信息 改用接口方式调用
            //外卖起送条件（1:杯数，2:金额）
            if (!Arrays.asList(1, 2).contains(storeDeliveryInfoDto.getDeliveryCondition())) {
                throw new ServiceException(ResponseResult.STORE_DISCONTENT_DELIVERY_CONDITION);
            }
            if (1 == storeDeliveryInfoDto.getDeliveryCondition()) {
                int sum = shoppingCartGoodsDto.getProducts().stream().mapToInt(ShoppingCartGoodsDto.CartGoodsDetailDto::getQty).sum();
                if (sum < storeDeliveryInfoDto.getFreeDeliveryCup()) {
                    throw new ServiceException(ResponseResult.STORE_DISCONTENT_DELIVERY_CUP);
                }
            }
            //订单金额小于起送费提示
            else if (2 == storeDeliveryInfoDto.getDeliveryCondition() && storeDeliveryInfoDto.getDeliveryLimitAmount() > shoppingCartGoodsDto.getTotalAmount()) {
                throw new ServiceException(ResponseResult.STORE_DISCONTENT_DELIVERY_FEE);
            }

            storeDeliveryInfoDto.setEnableTakeaway(true);
            // 校验收货地址是否可配送
            checkReceiveAddress(storeDeliveryInfoDto, createOrderVo);
        }
        return pushOrderTime;
    }

    public void checkOrderExpectTime(CreateOrderVo createOrderVo, StoreResponse.BizVO storeResponseDto, Date takeMealDateTime) {
        if (takeMealDateTime == null) {
            return;
        }
        //获取门店当天营业时间
        Date todayEndDate = null;
        List<String> todayBusinessTimes = storeCenterService.getTodayBusinessTime(Integer.parseInt(storeResponseDto.getBusinessType()), storeResponseDto.getBusinessHoursDay());
        if (CollectionUtils.isEmpty(todayBusinessTimes)) {
            throw new ServiceException(ResponseResult.STORE_BUSINESS_HOUR_ERROR);
        }
        BusinessDate businessDate = getStoreBusinessDate(todayBusinessTimes.get(todayBusinessTimes.size() - 1), true);
        todayEndDate = businessDate.getEndDate();
        //在当天营业时间内
        boolean expectTimeInTodayBusinessTime = true;
        Date date = new Date();
        Date newDate = DateUtil.convert2Date(date, DateUtil.FORMAT_yyyyMMdd_date);
        newDate = DateUtil.addDays(newDate, 1);
        //隔天预约(在明日凌晨之后且在门店营业结束之后)
        if (takeMealDateTime.after(todayEndDate) && takeMealDateTime.after(newDate)) {
            expectTimeInTodayBusinessTime = false;
        }
        if (expectTimeInTodayBusinessTime) {
            boolean inTodayBusinessTime = true;
            for (String todayTime : todayBusinessTimes) {
                //每段营业时间校验
                BusinessDate businessDate2 = getStoreBusinessDate(todayTime, true);
                if (takeMealDateTime.getTime() >= businessDate2.getStartDate().getTime()
                        && takeMealDateTime.getTime() <= businessDate2.getEndDate().getTime()) {
                    inTodayBusinessTime = false;
                    break;
                }
            }
            if (inTodayBusinessTime) {
                throw new ServiceException(ResponseResult.ORDER_TAKEMEALTIME_INVAILD);
            }
        }
        //隔天预约
        if (!expectTimeInTodayBusinessTime) {
            List<String> nextDayBusinessTimes = storeCenterService.getNextDayBusinessTime(Integer.parseInt(storeResponseDto.getBusinessType()), storeResponseDto.getBusinessHoursDay());
            boolean inNextDayBusinessTime = true;
            for (String nextDayTime : nextDayBusinessTimes) {
                BusinessDate storeNextBusinessDate = getStoreBusinessDate(nextDayTime, false);
                if (takeMealDateTime.getTime() >= storeNextBusinessDate.getStartDate().getTime()
                        && takeMealDateTime.getTime() <= storeNextBusinessDate.getEndDate().getTime()) {
                    inNextDayBusinessTime = false;
                    break;
                }
            }
            if (inNextDayBusinessTime) {
                throw new ServiceException(ResponseResult.ORDER_TAKEMEALTIME_INVALID);
            }
        }

        if (CreateOrderType.TAKE_OUT.getCode().equals(createOrderVo.getOrderType())) {
            String deliveryStr = storeResponseDto.getDeliveryHoursDay().replace("-", ",")
                    .replace("_", ",");
            String[] deliverys = deliveryStr.split(",");
            Date deliveryStartDate = null;
            Date deliveryEndDate = null;
            if (deliverys.length == 2) {
                SimpleDateFormat hhmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
                String startDateTimeStr = yyyyMMdd.format(date) + " " + deliverys[0] + ":00";
                String endDateTimeStr = yyyyMMdd.format(date) + " " + deliverys[1] + ":00";
                try {
                    deliveryEndDate = hhmmss.parse(endDateTimeStr);
                    deliveryStartDate = hhmmss.parse(startDateTimeStr);
                } catch (ParseException e) {
                    LogUtil.error("getStoreDeliveryInfo_error", endDateTimeStr, e.getMessage());
                }
            }
            if (deliveryStartDate == null || deliveryEndDate == null) {
                throw new ServiceException(ResponseResult.ORDER_CREATE_TIME_NOT_DELIVERY);
            }
            // 校验预约配送时间
            if (expectTimeInTodayBusinessTime && (takeMealDateTime.before(deliveryStartDate) || takeMealDateTime.after(deliveryEndDate))) {
                throw new ServiceException(ResponseResult.ORDER_CREATE_TIME_NOT_DELIVERY);
            }
            Date nextDeliveryStartDate = DateUtil.addDays(deliveryStartDate, 1);
            Date nextDeliveryEndDate = DateUtil.addDays(deliveryEndDate, 1);
            // 隔日预约外卖校验预约配送时间
            if (!expectTimeInTodayBusinessTime && (takeMealDateTime.before(nextDeliveryStartDate) || takeMealDateTime.after(nextDeliveryEndDate))) {
                throw new ServiceException(ResponseResult.ORDER_CREATE_TIME_NOT_DELIVERY);
            }
            checkTakeOutTime(storeResponseDto, date, takeMealDateTime, expectTimeInTodayBusinessTime);
        }
    }

    /**
     * 检验订单是否在外卖时间内
     *
     * @param storeResponseDto              店铺信息
     * @param now                           当前时间
     * @param takeMealDateTime              预约单送达时间/即时单下单时间
     * @param expectTimeInTodayBusinessTime 是否在当日营业时间内
     */
    private void checkTakeOutTime(StoreResponse.BizVO storeResponseDto, Date now, Date takeMealDateTime, boolean expectTimeInTodayBusinessTime) {
        String deliveryStr = storeResponseDto.getDeliveryHoursDay().replace("-", ",")
                .replace("_", ",");
        String[] deliverys = deliveryStr.split(",");
        Date deliveryStartDate = null;
        Date deliveryEndDate = null;
        if (deliverys.length == 2) {
            SimpleDateFormat hhmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
            String startDateTimeStr = yyyyMMdd.format(now) + " " + deliverys[0] + ":00";
            String endDateTimeStr = yyyyMMdd.format(now) + " " + deliverys[1] + ":00";
            try {
                deliveryStartDate = hhmmss.parse(startDateTimeStr);
                deliveryEndDate = hhmmss.parse(endDateTimeStr);
            } catch (ParseException e) {
                LogUtil.error("getStoreDeliveryInfo_error", endDateTimeStr, e.getMessage());
            }
        }
        if (deliveryStartDate == null || deliveryEndDate == null) {
            throw new ServiceException(ResponseResult.ORDER_CREATE_TIME_NOT_DELIVERY);
        }
        // 校验预约配送时间
        if (expectTimeInTodayBusinessTime && (takeMealDateTime.before(deliveryStartDate) || takeMealDateTime.after(deliveryEndDate))) {
            throw new ServiceException(ResponseResult.ORDER_CREATE_TIME_NOT_DELIVERY);
        }
        Date nextDeliveryStartDate = DateUtil.addDays(deliveryStartDate, 1);
        Date nextDeliveryEndDate = DateUtil.addDays(deliveryEndDate, 1);
        // 隔日预约外卖校验预约配送时间
        if (!expectTimeInTodayBusinessTime && (takeMealDateTime.before(nextDeliveryStartDate) || takeMealDateTime.after(nextDeliveryEndDate))) {
            throw new ServiceException(ResponseResult.ORDER_CREATE_TIME_NOT_DELIVERY);
        }
    }

    public Date getOrderExpectTime(String takeMealFlag, String takeMealTimes, String expectTime,
                                   CreateOrderType createOrderType, Integer serviceTime, StoreResponse.BizVO storeResponseDto) {
        Date takeMealDateTime = null;
        //0=到店单我已到店、外卖单尽快送出
        if (StringUtils.isNotBlank(takeMealFlag) && "0".equals(takeMealFlag)) {
            return takeMealDateTime;
        }
        if (StringUtils.isBlank(takeMealTimes) && StringUtils.isBlank(expectTime)) {
            return takeMealDateTime;
        }
        //兼容门店隔日预约单格式修改，HH:mm变yyyy-MM-dd HH:mm，前端未升级，未按要求传
        if (StringUtils.isNotBlank(takeMealTimes) && takeMealTimes.length() > 5) {
            expectTime = takeMealTimes + ":00";
        }

        Date date = new Date();
        //takeMealTimes格式必须为HH:mm
        if (StringUtils.isNotBlank(takeMealTimes) && takeMealTimes.length() <= 5) {
            StringBuffer takeMealTime = new StringBuffer("");
            takeMealTime = takeMealTime.append(DateUtil.convert2String(date, "yyyy-MM-dd"))
                    .append(" ").append(takeMealTimes).append(":00");
            takeMealDateTime = DateUtil.convert2Date(takeMealTime.toString(), "yyyy-MM-dd HH:mm:ss");
            Date newDate = DateUtil.convert2Date(date, DateUtil.FORMAT_yyyyMMdd_date);
            newDate = DateUtil.addDays(newDate, 1);

            //获取门店当天营业结束时间
            Date todayEndDate = null;
            List<String> todayBusinessTimes = storeCenterService.getTodayBusinessTime(Integer.parseInt(storeResponseDto.getBusinessType()), storeResponseDto.getBusinessHoursDay());
            if (CollectionUtils.isEmpty(todayBusinessTimes)) {
                throw new ServiceException(ResponseResult.STORE_BUSINESS_HOUR_ERROR);
            }
            BusinessDate businessDate = getStoreBusinessDate(todayBusinessTimes.get(todayBusinessTimes.size() - 1), true);
            todayEndDate = businessDate.getEndDate();

            //隔天营业的预约时间处理  计算出预约时间在当前时间之前，预约时间加1天 newDate.before(todayEndDate)=隔天营业
            if (takeMealDateTime != null && takeMealDateTime.before(date) && newDate.before(todayEndDate)) {
                takeMealDateTime = DateUtil.addDays(takeMealDateTime, 1);
            }
        }
        if (StringUtils.isNotBlank(expectTime)) {
            takeMealDateTime = DateUtil.convert2Date(expectTime, "yyyy-MM-dd HH:mm:ss");
        }
        //当顾客指定送达时间小于当前时间,订单记录类型为即时单
        if (takeMealDateTime != null && takeMealDateTime.before(date)) {
            takeMealDateTime = null;
        }
        //当顾客指定送达时间小于当前时间+提前预约时间时，订单记录类型为即时单
        if (CreateOrderType.TAKE_OUT.equals(createOrderType) && takeMealDateTime != null
                && serviceTime != null && takeMealDateTime.before(DateUtil.addMinutes(date, serviceTime))) {
            takeMealDateTime = null;
        }
        return takeMealDateTime;
    }

    public BusinessDate getStoreBusinessDate(String businessHoursDay, boolean today) {
        BusinessDate businessDate = new BusinessDate();
        //设置营业开始和结束时间
        String businessHourStr = businessHoursDay.replace("-", ",").replace("_", ",");
        String[] businessHours = businessHourStr.split(",");
        if (businessHours.length != 2) {
            throw new ServiceException(ResponseResult.STORE_NOT_FOUND);
        }
        Date date = new Date();
        if (!today) {
            date = DateUtil.addDays(date, 1);
        }
        String startDateTimeStr = DateUtil.convert2String(date, DateUtil.FORMAT_YMD) + " " + businessHours[0] + ":00";
        String endDateTimeStr = DateUtil.convert2String(date, DateUtil.FORMAT_YMD) + " " + businessHours[1] + ":00";
        Date startDateTime;
        Date endDateTime;
        startDateTime = DateUtil.convert2Date(startDateTimeStr, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS);
        SimpleDateFormat hhmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            endDateTime = hhmmss.parse(endDateTimeStr);
        } catch (ParseException e) {
            throw new ServiceException(ResponseResult.STORE_BUSINESS_HOUR_ERROR);
        }
        //隔天营业时间处理
        if (startDateTime.after(endDateTime)) {
            endDateTime = DateUtil.addDays(endDateTime, 1);
        }
        // 校验门店是否打烊，打烊了则不让操作
        if (startDateTime == null || endDateTime == null) {
            throw new ServiceException(ResponseResult.STORE_ITEM_STOP_BUSINESS);
        }
        businessDate.setStartDate(startDateTime);
        businessDate.setEndDate(endDateTime);
        return businessDate;
    }

    public ShoppingCartGoodsDto getShoppingCartGoodsDto(CreateOrderVo createOrderVo) {
        ShoppingCartInfoRequestVo.BuyMemberCard buyMemberCard = null;
        if (createOrderVo.getBuyMemberCard() != null) {
            buyMemberCard = new ShoppingCartInfoRequestVo.BuyMemberCard();
            buyMemberCard.setPaidId(createOrderVo.getBuyMemberCard().getPaidId());
            buyMemberCard.setRuleId(createOrderVo.getBuyMemberCard().getRuleId());
        }
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = ShoppingCartInfoRequestVo.builder()
                .partnerId(createOrderVo.getPartnerId())
                .shopId(createOrderVo.getShopId())
                .version(createOrderVo.getVersion())
                .sessionId(createOrderVo.getSessionId())
                .orderType(createOrderVo.getOrderType())
                .reachStoreType(createOrderVo.getReachStoreType())
                .flag(CouponFlag.NO.getCode())
                .receiveId(createOrderVo.getReceiveId())
                .useCustomerScore(createOrderVo.getUseCustomerScore())
                .buyMemberCard(buyMemberCard)
                .menuType(createOrderVo.getMenuType())
                .build();
        // 如果使用优惠券或者商品券，校验 couponCode
        if (StringUtils.isNotBlank(createOrderVo.getCouponCode())) {
            // 校验couponCode
            GetCouponDetailResponseDto getCouponDetailResponseDto = couponService.getMemberCoupon(GetMemberCouponRequestVo.builder()
                    .partnerId(createOrderVo.getPartnerId())
                    .couponCode(createOrderVo.getCouponCode()).build());
            if (Objects.equals(getCouponDetailResponseDto, null) || CollectionUtils.isEmpty(getCouponDetailResponseDto.getDetails())
                    || getCouponDetailResponseDto.getDetails().get(0).getActive() == null
                    || getCouponDetailResponseDto.getDetails().get(0).getActive().getActiveCode() == null) {
                if ((CollectionUtils.isNotEmpty(getCouponDetailResponseDto.getDetails().get(0).getActiveRestrictionVOS())
                        && CollectionUtils.isEmpty(getCouponDetailResponseDto.getDetails().get(0).getActiveRestrictionVOS().stream()
                        .filter(a -> Objects.equals(a.getStoreIdPartner(), createOrderVo.getShopId())).collect(Collectors.toList()))
                )) {
                    throw new ServiceException(ResponseResult.COUPON_SHOP_NOTSUPPORT);
                } else {
                    throw new ServiceException(ResponseResult.COUPON_GETINFO_INVAILD);
                }
            }
            String activeCode = getCouponDetailResponseDto.getDetails().get(0).getActive().getActiveCode();
            // 校验点餐方式,查询购物车接口内部已校验
            shoppingCartInfoRequestVo.setCouponCode(createOrderVo.getCouponCode());
            // 活动code
            shoppingCartInfoRequestVo.setActivityCode(activeCode);
            shoppingCartInfoRequestVo.setCardCode(createOrderVo.getCardCode());
        }

        // 如果批量使用优惠券或者商品券，校验 couponCode
        List<ShoppingCartInfoRequestVo.couponCode> couponCodes = new ArrayList();
        if (createOrderVo.getCouponCodes() != null && !createOrderVo.getCouponCodes().isEmpty()) {
            createOrderVo.getCouponCodes().forEach(couponCode->{
                // 校验couponCode
                GetCouponDetailResponseDto getCouponDetailResponseDto = couponService.getMemberCoupon(GetMemberCouponRequestVo.builder()
                        .partnerId(createOrderVo.getPartnerId())
                        .couponCode(couponCode).build());
                if (Objects.equals(getCouponDetailResponseDto, null) || CollectionUtils.isEmpty(getCouponDetailResponseDto.getDetails())
                        || getCouponDetailResponseDto.getDetails().get(0).getActive() == null
                        || getCouponDetailResponseDto.getDetails().get(0).getActive().getActiveCode() == null) {
                    if ((CollectionUtils.isNotEmpty(getCouponDetailResponseDto.getDetails().get(0).getActiveRestrictionVOS())
                            && CollectionUtils.isEmpty(getCouponDetailResponseDto.getDetails().get(0).getActiveRestrictionVOS().stream()
                            .filter(a -> Objects.equals(a.getStoreIdPartner(), createOrderVo.getShopId())).collect(Collectors.toList()))
                    )) {
                        throw new ServiceException(ResponseResult.COUPON_SHOP_NOTSUPPORT);
                    } else {
                        throw new ServiceException(ResponseResult.COUPON_GETINFO_INVAILD);
                    }
                }
                String activeCode = getCouponDetailResponseDto.getDetails().get(0).getActive().getActiveCode();
                ShoppingCartInfoRequestVo.couponCode coupon = new ShoppingCartInfoRequestVo.couponCode();
                coupon.setCouponCode(couponCode);
                coupon.setActivityCode(activeCode);
                couponCodes.add(coupon);
            });

            if(StringUtils.isEmpty(shoppingCartInfoRequestVo.getCardCode())){
                shoppingCartInfoRequestVo.setCardCode(createOrderVo.getCardCode());
            }
        }

        shoppingCartInfoRequestVo.setCouponCodes(couponCodes);

        // 通过购物车获取优惠信息
        GetShoppingCartGoodsApportionDto requestDto = new GetShoppingCartGoodsApportionDto();
        // 设置用户选择的买一赠一商品信息
        shoppingCartInfoRequestVo.setChooseGoods(JSONArray.parseArray(JSONObject.toJSONString(createOrderVo.getChooseGoods()), ShoppingCartInfoRequestVo.ChooseGood.class));
        requestDto.setShoppingCartInfoRequestVo(shoppingCartInfoRequestVo);
        //加价购商品 校验放购物车校验
        requestDto.setPremiumExchangeActivity(createOrderVo.getPremiumExchangeActivity());
        // 若为拼单类型，购物车信息从新的拼单购物车获取 update by miaohui for 【ID1010972】 多人拼单
        cn.freemud.base.entity.BaseResponse<ShoppingCartGoodsDto> apportionResponse;
        if (this.isCollageOrder(createOrderVo)) {
            apportionResponse = shoppingCartClient.getCollageShoppingCartGoodsApportion(requestDto);
        } else {
            apportionResponse = shoppingCartClient.getShoppingCartGoodsApportionNew(requestDto);
        }
        if (!ObjectUtils.equals(ResponseCodeConstant.RESPONSE_SUCCESS_STR, apportionResponse.getCode())) {
            ResponseResult responseResult = ResponseResult.getResponseResult(apportionResponse.getCode());
            throw new ServiceException(responseResult != null ? responseResult : ResponseResult.SHOPPING_CART_GETINFO_ERROR);
        }
        if (apportionResponse.getResult() == null || CollectionUtils.isEmpty(apportionResponse.getResult().getProducts())) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_GETINFO_INVAILD);
        }
        ShoppingCartGoodsDto shoppingCartGoodsDto = apportionResponse.getResult();
        if (shoppingCartGoodsDto.getOriginalTotalAmount() == null) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_GETINFO_INVAILD);
        }

        // 拼单处理
        if (this.isCollageOrder(createOrderVo)) {
            // 处理拼单加购人信息
            List<ShoppingCartGoodsDto.CartGoodsDetailDto> products = shoppingCartGoodsDto.getProducts();
            ShoppingCartGoodsDto.CartGoodsDetailDto createUserGood = products.stream().filter(good -> createOrderVo.getUserId().equals(good.getUserId())).findFirst().orElse(null);

            if (null == createUserGood) {
                // 若拼单发起人未购买商品，则将赠品按购物车行分给加购人
                products.stream().filter(good -> null == good.getUserId()).collect(Collectors.toList()).forEach(cartGoodsNullUser -> {
                    ShoppingCartGoodsDto.CartGoodsDetailDto parentGood = products.stream().filter(good -> good.getCartGoodsUid().equals(cartGoodsNullUser.getCartGoodsUid())).findFirst().orElse(null);
                    cartGoodsNullUser.setUserId(parentGood == null ? createOrderVo.getUserId() : parentGood.getUserId());
                    cartGoodsNullUser.setOpenId(parentGood == null ? null : parentGood.getOpenId());
                    cartGoodsNullUser.setUserName(parentGood == null ? null : parentGood.getUserName());
                    cartGoodsNullUser.setPhotoUrl(parentGood == null ? null : parentGood.getPhotoUrl());
                });
            } else {
                products.stream().filter(good -> null == good.getUserId()).collect(Collectors.toList()).forEach(cartGoodsNullUser -> {
                    cartGoodsNullUser.setUserId(createUserGood.getUserId());
                    cartGoodsNullUser.setOpenId(createUserGood.getOpenId());
                    cartGoodsNullUser.setUserName(createUserGood.getUserName());
                    cartGoodsNullUser.setPhotoUrl(createUserGood.getPhotoUrl());
                });
            }
        }

        return shoppingCartGoodsDto;
    }

    /**
     * 获取门店配送信息
     */
    public StoreDeliveryInfoDto getStoreDeliveryInfo(StoreResponse.BizVO storeResponseDto,
                                                     AssortmentOpenPlatformIappWxappConfig openPlatformIappWxappConfig, String wxAppid) {
        StoreDeliveryInfoDto storeDeliveryInfoDto = new StoreDeliveryInfoDto();
        storeDeliveryInfoDto.setPartnerId(storeResponseDto.getPartnerId());
        storeDeliveryInfoDto.setStoreId(storeResponseDto.getStoreCode());
        storeDeliveryInfoDto.setStoreName(storeResponseDto.getStoreName());
        // 查询外卖配送信息
        AssortmentOpenPlatformPartnerStoreDeliveryConfig deliveryConfig = deliveryConfigManager.findByPartnerIdAndStoreCode(storeResponseDto.getPartnerId(),
                storeResponseDto.getStoreCode());
        if (deliveryConfig == null) {
            throw new ServiceException(ResponseResult.STORE_ITEM_NOT_DELIVERY);
        }
        // 判断门店是否启用外卖，只有当小程序开通外卖，且门店开通外卖,设置 外卖配送时间 才开启外卖功能
        storeDeliveryInfoDto.setDeliveryLimitAmount(deliveryConfig == null ? 0 : deliveryConfig.getDeliveryLimitAmount());
        storeDeliveryInfoDto.setDeliveryAmount(deliveryConfig == null ? 0 : deliveryConfig.getDeliveryAmount());
        storeDeliveryInfoDto.setDefaultDeliveryRange(deliveryConfig == null ? 0L : deliveryConfig.getDefaultDeliveryRange());
        storeDeliveryInfoDto.setAddRangeAmount(deliveryConfig == null ? 0L : deliveryConfig.getAddRangeAmount());
        storeDeliveryInfoDto.setAddRangeCount(deliveryConfig == null ? 0L : deliveryConfig.getAddRangeCount());
        storeDeliveryInfoDto.setPoint2DList(getDeliveryPoint2DList(storeResponseDto.getDistributionScope()));
        storeDeliveryInfoDto.setDeliveryHoursDay(storeResponseDto.getDeliveryHoursDay());
        storeDeliveryInfoDto.setLongitude(storeResponseDto.getLongitude());
        storeDeliveryInfoDto.setLatitude(storeResponseDto.getLatitude());
        storeDeliveryInfoDto.setScopeConfig(storeResponseDto.getScopeConfig());
        if (StringUtils.isNotEmpty(storeResponseDto.getDeliveryRadius())) {
            storeDeliveryInfoDto.setDeliveryRadius(Integer.valueOf(storeResponseDto.getDeliveryRadius()));
        } else {
            storeDeliveryInfoDto.setDeliveryRadius(0);
        }
        // 只有小程序设置了外卖，并且开通了第三方配送账户，才是第三方配送单
        if (openPlatformIappWxappConfig == null) {
            openPlatformIappWxappConfig = openPlatformIappWxappConfigManager.selectIappWxappConfigByWxAppId(wxAppid);
        }
        if (openPlatformIappWxappConfig == null) {
            storeDeliveryInfoDto.setDeliveryType("self");
            storeDeliveryInfoDto.setPushOrderTime(0);
        } else {
            if (ObjectUtils.equals(openPlatformIappWxappConfig.getTakeType(), 1)) {
                storeDeliveryInfoDto.setDeliveryType("self");
                storeDeliveryInfoDto.setPushOrderTime(0);
            } else {
                storeDeliveryInfoDto.setDeliveryType("third");
                storeDeliveryInfoDto.setPushOrderTime(0);
            }
        }
        return storeDeliveryInfoDto;
    }

    /**
     * 获取门店配送信息
     */
    public StoreDeliveryInfoDto getNewStoreDeliveryInfo(StoreResponse.BizVO storeResponseDto,
                                                        AssortmentOpenPlatformIappWxappConfig openPlatformIappWxappConfig, String wxAppid, String trackingNo) {
        StoreDeliveryInfoDto storeDeliveryInfoDto = new StoreDeliveryInfoDto();
        storeDeliveryInfoDto.setPartnerId(storeResponseDto.getPartnerId());
        storeDeliveryInfoDto.setStoreId(storeResponseDto.getStoreCode());
        storeDeliveryInfoDto.setStoreName(storeResponseDto.getStoreName());
        // 查询外卖配送信息
        QueryDeliveryRequest queryDeliveryRequest = new QueryDeliveryRequest();
        queryDeliveryRequest.setPartnerId(storeResponseDto.getPartnerId());
        queryDeliveryRequest.setStoreCode(storeResponseDto.getStoreCode());
        BaseResponse<QueryDeliverDetailResponse> queryDeliverDetailResponse = storeCenterService.queryDeliverDetail(queryDeliveryRequest, trackingNo);
        if (queryDeliverDetailResponse == null || !ResponseResult.SUCCESS.getCode().equals(queryDeliverDetailResponse.getCode()) || queryDeliverDetailResponse.getData() == null) {
            throw new ServiceException(ResponseResult.STORE_ITEM_NOT_DELIVERY);
        }
        QueryDeliverDetailResponse deliveryDetail = queryDeliverDetailResponse.getData();
        // 判断门店是否启用外卖，只有当小程序开通外卖，且门店开通外卖,设置 外卖配送时间 才开启外卖功能
        storeDeliveryInfoDto.setDeliveryLimitAmount(StringUtils.isBlank(deliveryDetail.getMinOrderPrice()) ? 0L : Long.parseLong(deliveryDetail.getMinOrderPrice()));
        storeDeliveryInfoDto.setDeliveryAmount(StringUtils.isBlank(deliveryDetail.getDeliveryFee()) ? 0L : Long.parseLong(deliveryDetail.getDeliveryFee()));
        storeDeliveryInfoDto.setDefaultDeliveryRange(StringUtils.isBlank(deliveryDetail.getDeliveryRange()) ? 0L : Long.parseLong(deliveryDetail.getDeliveryRange()));
        storeDeliveryInfoDto.setAddRangeAmount(StringUtils.isBlank(deliveryDetail.getAddRangeAmount()) ? 0L : Long.parseLong(deliveryDetail.getAddRangeAmount()));
        storeDeliveryInfoDto.setAddRangeCount(StringUtils.isBlank(deliveryDetail.getAddRange()) ? 0L : Long.parseLong(deliveryDetail.getAddRange()));
        storeDeliveryInfoDto.setPoint2DList(getDeliveryPoint2DList(storeResponseDto.getDistributionScope()));
        storeDeliveryInfoDto.setDeliveryHoursDay(storeResponseDto.getDeliveryHoursDay());
        storeDeliveryInfoDto.setLongitude(storeResponseDto.getLongitude());
        storeDeliveryInfoDto.setLatitude(storeResponseDto.getLatitude());
        storeDeliveryInfoDto.setScopeConfig(storeResponseDto.getScopeConfig());
        if (StringUtils.isNotEmpty(storeResponseDto.getDeliveryRadius())) {
            storeDeliveryInfoDto.setDeliveryRadius(Integer.valueOf(storeResponseDto.getDeliveryRadius()));
        } else {
            storeDeliveryInfoDto.setDeliveryRadius(0);
        }
        // 只有小程序设置了外卖，并且开通了第三方配送账户，才是第三方配送单
        if (openPlatformIappWxappConfig == null) {
            openPlatformIappWxappConfig = openPlatformIappWxappConfigManager.selectIappWxappConfigByWxAppId(wxAppid);
        }
        if (openPlatformIappWxappConfig == null) {
            storeDeliveryInfoDto.setDeliveryType("self");
            storeDeliveryInfoDto.setPushOrderTime(0);
        } else {
            if (ObjectUtils.equals(openPlatformIappWxappConfig.getTakeType(), 1)) {
                storeDeliveryInfoDto.setDeliveryType("self");
                storeDeliveryInfoDto.setPushOrderTime(0);
            } else {
                storeDeliveryInfoDto.setDeliveryType("third");
                storeDeliveryInfoDto.setPushOrderTime(0);
            }
        }
        storeDeliveryInfoDto.setDeliveryCondition(deliveryDetail.getDeliveryType());
        storeDeliveryInfoDto.setFreeDeliveryCup(deliveryDetail.getFreeDeliveryCup());
        return storeDeliveryInfoDto;
    }

    /**
     * 获取配送范围内集合
     */
    public List<Point2D.Double> getDeliveryPoint2DList(String distributionScope) {
        if (StringUtils.isBlank(distributionScope)) {
            return Collections.emptyList();
        }
        /**
         * 如果点不为整数，返回空
         */
        String[] points = distributionScope.split(",");
        if (points.length % 2 != 0) {
            return Collections.emptyList();
        }
        List<String> pointList = Arrays.asList(points);
        List<Point2D.Double> point2DList = Lists.newArrayList();
        for (int i = 0; i < pointList.size(); i++) {
            Double pointX = Double.parseDouble(pointList.get(i));
            Double pointY = Double.parseDouble(pointList.get(++i));
            point2DList.add(new Point2D.Double(pointX, pointY));
        }
        return point2DList;
    }

    /**
     * 校验收货地址是否可配送
     */
    public void checkReceiveAddress(StoreDeliveryInfoDto storeDeliveryInfoDto, CreateOrderVo createOrderVo) {
        //校验收货地址是否可配送
        String receiveId = createOrderVo.getReceiveId();
        String trackingNo = LogThreadLocal.getTrackingNo();
        QueryReceiveAddressRequest request = new QueryReceiveAddressRequest(receiveId, storeDeliveryInfoDto.getPartnerId());
        BaseResponse<QueryReceiveAddressResponse> queryReceiveAddressResponse = memberCenterService.queryReceiveAddressById(request, trackingNo);
        if (!ResponseResult.SUCCESS.getCode().equals(queryReceiveAddressResponse.getCode()) || queryReceiveAddressResponse.getData() == null) {
            throw new ServiceException(ResponseResult.USER_GETRECEIVEADDRESS_ERROR);
        }
        QueryReceiveAddressResponse receiveAddressResult = queryReceiveAddressResponse.getData();
        UserDeliveryInfoDto userDeliveryInfoDto = storeService.getUserDeliveryInfo(storeDeliveryInfoDto, receiveAddressResult.getLongitude(),
                receiveAddressResult.getLatitude());
        if (!userDeliveryInfoDto.getUserEnableTakeaway()) {
            throw new ServiceException(ResponseResult.ORDER_TAKE_OUT_ADDRESS_NOT_DELIVERY);
        }
        userDeliveryInfoDto.setReceiveUserName(receiveAddressResult.getReceiveName());
        userDeliveryInfoDto.setReceiveMobile(StringUtils.isEmpty(receiveAddressResult.getMobile()) ? receiveAddressResult.getReceiveMobile() : receiveAddressResult.getMobile());
        String receiveAddress = receiveAddressResult.getReceiveAddress();
        if (StringUtils.isNotBlank(receiveAddress)) {
            userDeliveryInfoDto.setReceiveAddress(receiveAddress);
            if (receiveAddress.contains("officeName") && receiveAddress.contains("address")) {
                JSONObject jsonObject = JSONObject.parseObject(receiveAddress);
                userDeliveryInfoDto.setReceiveOfficeName(jsonObject.getString("officeName"));
                userDeliveryInfoDto.setReceiveAddress(jsonObject.getString("address"));
            }
        }

        createOrderVo.setUserName(receiveAddressResult.getReceiveName());
        createOrderVo.setMobile(StringUtils.isEmpty(receiveAddressResult.getMobile()) ? receiveAddressResult.getReceiveMobile() : receiveAddressResult.getMobile());
        createOrderVo.setUserDeliveryInfoDto(userDeliveryInfoDto);
    }


    public void checkCardCode(String partnerId, String memberId, String cardCode) {
        if (StringUtils.isBlank(cardCode)) {
            return;
        }
        StatisticalPropertyRequest request = new StatisticalPropertyRequest();
        request.setPartnerId(partnerId);
        request.setMemberId(memberId);
        BaseResponse<List<GetSvcInfoByMemberIdResponse>> responseDTO = memberPropertyService.getSvcInfoByMemberId(request, LogThreadLocal.getTrackingNo());
        if (!ResponseResult.SUCCESS.getCode().equals(responseDTO.getCode()) || responseDTO.getData() == null
                || responseDTO.getData().size() == 0) {
            throw new ServiceException(ResponseResult.USER_SVC_CARD_ERROR);
        }
        //svc卡无效
        boolean b = true;
        for (GetSvcInfoByMemberIdResponse getSvcInfoByMemberIdResponse : responseDTO.getData()) {
            if (cardCode.equals(getSvcInfoByMemberIdResponse.getCardCode()) && getSvcInfoByMemberIdResponse.getStatusFlag() == 0) {
                b = false;
            }
        }
        if (b) {
            throw new ServiceException(ResponseResult.USER_SVC_CARD_ERROR);
        }
    }

    public void checkOrderByStore(StoreResponse.BizVO storeResponseDto) {
        // 校验门店是否停业 1 营业 2 停业 3 繁忙置休
        if (storeResponseDto.getActiveFlag() == null || storeResponseDto.getActiveFlag() != 1) {
            throw new ServiceException(ResponseResult.STORE_ITEM_STOP_BUSINESS);
        }
//        //设置营业开始和结束时间
//        String businessHourStr = storeResponseDto.getBusinessHoursDay().replace("-", ",").replace("_", ",");
//        String[] businessHours = businessHourStr.split(",");
//        if (businessHours.length != 2) {
//            throw new ServiceException(ResponseResult.STORE_NOT_FOUND);
//        }
//        Date date = new Date();
//        String startDateTimeStr = DateUtil.convert2String(date, DateUtil.FORMAT_YMD) + " " + businessHours[0] + ":00";
//        String endDateTimeStr = DateUtil.convert2String(date, DateUtil.FORMAT_YMD) + " " + businessHours[1] + ":00";
//        Date startDateTime ;
//        Date endDateTime ;
//        startDateTime = DateUtil.convert2Date(startDateTimeStr, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS);
//        SimpleDateFormat hhmmss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        try {
//            endDateTime = hhmmss.parse(endDateTimeStr);
//        } catch (ParseException e) {
//            throw new ServiceException(ResponseResult.STORE_BUSINESS_HOUR_ERROR);
//        }
//        //隔天营业时间处理
//        if(startDateTime.after(endDateTime)){
//            endDateTime = DateUtil.addDays(endDateTime,1);
//        }
//        storeResponseDto.setBusinessHoursDayStartTime(startDateTime);
//        storeResponseDto.setBusinessHoursDayEndTime(endDateTime);
//
//        // 校验门店是否打烊，打烊了则不让操作
//        if (storeResponseDto.getBusinessHoursDayStartTime() == null
//                || storeResponseDto.getBusinessHoursDayEndTime() == null) {
//            throw new ServiceException(ResponseResult.STORE_ITEM_STOP_BUSINESS);
//        }
    }

    /**
     * 判断是否为拼单订单
     * @param createOrderVo
     * @return
     */
    private boolean isCollageOrder(CreateOrderVo createOrderVo) {
        return createOrderVo.getMarketingType() != null && OrderMarketType.COLLAGE.getIndex() == createOrderVo.getMarketingType();
    }

}
