/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/15 15:11
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.dto.ProductGroupDto;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class ProductVo {

    private Long id;
    /**
     * 商品重量
     */
    private Double weight;
    /**
     * 称重商品是否称重
     */
    private boolean weightType = true;
    /**
     * 商品ID
     */
    private String pid;
    /**
     * 商品名称
     */
    private String name;
    /**
     * 商品spu名称
     */
    private String spuName;

    /**
     * 加购人ID
     */
    private String userId;

    /**
     * 加购人openId
     */
    private String openId;

    /**
     * 加购人昵称
     */
    private String nickName;

    /**
     * 加购人头像
     */
    private String photoUrl;

    /**
     * 加购人包装费
     */
    private Long packPrice;

    /**
     * 商品的规格信息加属性信息
     */
    private String extras;
    /**
     * 标准价格  精确到分
     */
    private Long originalPrice;
    /**
     * 销售价
     */
    private Long finalPrice;
    /**
     * 默认图片
     */
    private String picture;
    /**
     * 分类名称
     */
    private String categoryName;
    /**
     * 产品组信息
     */
    List<ProductGroupDto> productGroups;
    /**
     * 商品标签信息
     */
    List<ProductLabel> productLabels;
    /**
     * 商品类型  1=普通商品,2=附加商品,3=组合商品，4=固定套餐，5=组合套餐
     */
    private Integer type;
    /**
     * 描述
     */
    private String specification;
    /**
     * 备注
     */
    private String remark;
    /**
     * 商品排序
     */
    private int sequence;
    /**
     * 商品数量
     */
    private Integer qty;
    /**
     * 商品状态   1 下架 2 上架 3 售罄 ，已卖光
     */
    private Integer status;

    private String statusDesc;
    /**
     * 腾讯商品推荐id
     */
    private String traceId;
    /**
     * 商品原总价  订单详情展示 v1.5.2版本增加
     */
    private Long originalTotalAmount;
    /**
     * 商品现总价 不包含满减,包含限时特价 订单详情展示 V1.5.2版本增加
     */
    private Long saleTotalAmount;
    /**
     * 属性名称 订单详情展示 V1.5.2版本增加
     */
    private String attributeNames;
    /**
     * 是否包含商品券 V1.5.2版本增加
     */
    private Boolean hasProductCoupon = false;

    /**
     * 套餐-父级id
     */
    private String parentProductId;

    /**
     * 套餐-type:6
     */
    private Integer productType;

    /**
     * 商品单位
     */
    private String unit;
    private String couponName;

    /**
     * 1.5.5版本添加
     * 商品参与活动类型(61:买一赠一)
     */
    private Integer activityType;
    @Data
    @NoArgsConstructor
    public static class ProductLabel {

        private String labelName;

    }

    /**
     * 套餐子集商品
     */
    private List<ProductVo> setMealProducts;

    private List<InventedParentActivityVo> InventedParentActivitiesVo;

    private List<ProductVo> setMaterialProducts;

    /**
     * 购物车行uid
     */
    private String cid;

    /**
     * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
     */
    private String ocid;

}
