/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;

import java.util.List;

@Data
public class ShoppingCartGoodsResponseVo  extends ShoppingCartGoodsBaseResponseVo{

    /**
     * 商品额外的属性
     */
    List<CartGoods> products;
    /**
     * 商品总数
     */
    private Integer productsCount;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价
     */
    private Long totalDiscountAmount;
    /**
     * 包装费
     */
    private Long packAmount;

    /**
     * 新包装费（该字段给新版本前端展示，使其好计算）
     */
    private Long newPackAmount;

    /**
     * 优惠券折扣
     */
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    private Long fullDiscount;
    /**
     * svc卡支付描述
     */
    private String svcDiscountDesc;

    /**
     * svc卡开关标识
     */
    private boolean svcSwitch;

    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;

    private ActivityTip buyOneGetActivity;
    /**
     * 积分抵扣优惠
     */
    private ShoppingCartCustomerScoreVo customerScoreVo;
    /**
     * 起送费
     */
    private Long freeDeliveryPrice;
    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;
}
