/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

//券活动测试 地址：http://115.159.65.101:8003 线上 http://10.51.0.7:8003
@FeignClient(name = "promotion-service", url = "${saas.activityclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface ActivityClient {

    /**
     * 统一活动查询接口
     */
    @PostMapping("/activity/query")
    @IgnoreFeignLogAnnotation(logMessage="query", excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    ActivityQueryResponseDto query(ActivityQueryRequestDto activityQueryRequestDto);

    /**
     * 优惠金额计算
     */
    @PostMapping("/calculation/discount")
    @IgnoreFeignLogAnnotation(logMessage="calculationDiscount",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    ActivityCalculationDiscountResponseDto calculationDiscount(ActivityCalculationDiscountRequestDto activityCalculationDiscountRequestDto);

    /**
     * 扣减库存
     */
    @PostMapping("/activity/stock/subtractStock")
    @IgnoreFeignLogAnnotation(logMessage="updateStock",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    ActivityBaseResponseDto updateStock(ActivityUpdateStockRequestDto activityUpdateStockRequestDto);

    /**
     * 库存冲正接口
     */
    @PostMapping("/activity/stock/cancelStock")
    @IgnoreFeignLogAnnotation(logMessage = "cancelStock",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    ActivityBaseResponseDto cancelStock(ActivityCancelStockRequestDto activityCancelStockRequestDto);



    /**
     * 新版优惠均摊计算
     * @param activityCalculationDiscountRequestDto
     * @return
     */
    @PostMapping("/calculation/discount/sharing")
    @IgnoreFeignLogAnnotation(logMessage = "calculationDiscountSharing",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    ActivityCalculationDiscountResponseDto calculationDiscountSharing(ActivityCalculationDiscountRequestDto activityCalculationDiscountRequestDto);


    /**
     * 促销新的算价对接
     */
    @PostMapping("/promotioncenter/calculateservice/discount/sharing")
    //@IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    CalculationSharingDiscountResponseDto calculationSharingDiscount(CalculationSharingDiscountRequestDto shareDiscountRequestDto);
}
