package cn.freemud.client;

import cn.freemud.adapter.ActivityAdapter;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.entities.dto.ActivityCancelStockRequestDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.utils.FileUtil;
import cn.freemud.utils.AppLogUtil;
import com.alibaba.fastjson.JSON;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Arrays;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MqTest {
    @Autowired
    private ActivityAdapter activityAdapter;
    @Value("${program.backorders_notify_activity_queue}")
    private String backOrdersNotifyActivityQueue;
    @Value("${program.backorders_notify_activity_exchange}")
    private String backOrdersNotifyActivityExchange;
    @Autowired
    private MQService mqService;
    @Test
    public void mqTest () {
        String fileName = "test";
        QueryOrdersResponseDto.DataBean.OrderBean orderBean = FileUtil.getObjectFromFile(fileName, QueryOrdersResponseDto.DataBean.OrderBean.class);
        // 删除订单 通知活动添加商品库存
        ActivityCancelStockRequestDto activityCancelStockRequestDto = activityAdapter.convert2ActivityCancelStockRequestDto(
                orderBean, Arrays.asList(1,2,3));
        System.out.println(JSON.toJSONString(activityCancelStockRequestDto));
        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersNotifyActivity", orderBean.getOid(), backOrdersNotifyActivityQueue);
            MQMessage<ActivityCancelStockRequestDto> message = new MQMessage<>(header, activityCancelStockRequestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersNotifyActivityQueue, message);
        } catch (Exception e) {
            AppLogUtil.errorLog("ActivityReverse", JSON.toJSONString(activityCancelStockRequestDto), "", e);
        }

    }
}
