package cn.freemud.service.impl.mcoffee.entity;

import cn.freemud.entities.vo.CartGoods;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020-10-26 13:59:32
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class CouponAvailableReqByCart {
    /**
     * 渠道id
     */
    private String providerId;
    /**
     * 商户号
     */
    private String merchantId;
    private String city;
    private String storeId;

    /**
     * 组织机构id列表（校验渠道限制）
     */
    private List<String> channelIdList;

    /**
     * 组织机构code列表（校验渠道限制）
     */
    private List<String> channelCodeList;

    /**
     * 券码列表
     */
    private List<String> couponCodes;
    private Integer totalAmount;

    /**
     * 核销渠道 枚举: mocoffee_wx : 麦咖啡微信小程序 mocoffee_zfb : 麦咖啡支付宝小程序
     */
    private String redeemChannel;

    /**
     * 购物车商品列表
     */
    private List<CartGoods> productList;

    private String stationId;
    private String operatorId;
}
