/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * 用户退货快递信息
 *
 * @author shichang.wang 2021/4/15
 */
@ApiModel("用户退货快递信息")
@Data
public class EditAfterSalesExpressVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    @NotEmpty(message = "订单编号不能为空")
    @ApiModelProperty("订单号")
    private String oid;

    @ApiModelProperty("商户ID")
    private String partnerId;


    /**
     * 物流公司名称
     */

    @NotEmpty(message = "物流公司名称不能为空")
    @ApiModelProperty("物流公司名称")
    private String expressChannelName;

    /**
     * 物流单号
     */
    @NotEmpty(message = "物流单号 不能为空")
    @ApiModelProperty("物流单号")
    private String expressNo;



}
