package cn.freemud.annotations;

import java.lang.annotation.*;


/**
 * @author freemud
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(value = {ElementType.METHOD})
@Documented
@Inherited
public @interface LogIgnoreFeign {

    String logMessage() default "";  // 输出方法名称，用以识别：Apollo临时开关temp-print-body-log-methods

    boolean printInfoLog() default false; // 若设置为true，则会永久打印

    String[] excludeStatusCodes() default "100"; // 设置系统除了100/200等正常状态码之外，依然会打印响应报文

    String statusCodeFieldName() default "code"; // 兼容基础服务返回statusCode字段

    String messageFieldName() default "message"; // 兼容基础服务返回message字段
}
