package cn.freemud.demo.service.impl;

import cn.freemud.demo.entities.bo.goods.BenefitBeanBO;
import cn.freemud.demo.entities.bo.goods.CalculationDiscountBO;
import cn.freemud.demo.entities.bo.promotion.ActivityBO;
import cn.freemud.demo.service.MessageService;
import cn.freemud.entities.vo.ActivityList;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.utils.WebUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class MessageServiceImpl implements MessageService {
    @Override
    public List<ActivityList> fullReduceMessage(CalculationDiscountBO.CalculationDiscountResult discountResult, StringBuilder messageBuilder, ActivityBO activityBO) {
        List<ActivityList> activityList = null;
        if (discountResult == null || CollectionUtils.isEmpty(discountResult.getGoods())) {
            if (activityBO != null && CollectionUtils.isNotEmpty(activityBO.getBenefits())) {
                List<BenefitBeanBO> benefitBeanBOList = activityBO.getBenefits();
                BenefitBeanBO benefitBeanBO = benefitBeanBOList.get(0);
                //调用没有加入购物车的提示语的方法
                activityList = setMessageNotInShoppingCart(messageBuilder, activityBO, benefitBeanBOList, benefitBeanBO);
            }

        } else {
            //促销返回满减提示语
            List<CalculationDiscountBO.CalculationDiscountResult.ActivityPrompt> activityPrompts = discountResult.getActivityPrompts();
            /**
             * 构建提示语
             */
            if (CollectionUtils.isNotEmpty(activityPrompts)) {
                activityList = setMessageSatisfyCart(messageBuilder, activityPrompts, activityBO);
            }
            else {
                activityList = setMessageNoSatisfyCart(messageBuilder, discountResult.getDiscounts());
            }
        }
        return activityList;
    }

    /**
     * 设置没有加入购物车的提示语
     * @param messageBuilder
     */
    private ArrayList<ActivityList> setMessageNotInShoppingCart(StringBuilder messageBuilder, ActivityBO activityBO, List<BenefitBeanBO> benefitBeanBOList, BenefitBeanBO benefitBeanBO) {

        ArrayList<ActivityList> activityList = new ArrayList<>();
        if (Objects.equals(ActivityTypeEnum.TYPE_11.getCode(), activityBO.getActivityType())) {
            messageBuilder.append("每满 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(benefitBeanBO.getThresholdAmount() * 1.00 / 100))
                    .append("</span> 减 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(benefitBeanBO.getDiscountAmount() * 1.00 / 100))
                    .append("</span> ")
                    .append("最高减 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(activityBO.getMaxMoney() * 1.00 / 100))
                    .append("</span> 元");

            //满足  x 元 减 Y 元 ，最高 减 Z元
            ActivityList notInShopping = new ActivityList();
            notInShopping.setTipType(1);
            notInShopping.setSatisfy(WebUtil.formatAmount(benefitBeanBO.getThresholdAmount() * 1.00 / 100).toString());
            notInShopping.setDeduct(WebUtil.formatAmount(benefitBeanBO.getDiscountAmount() * 1.00 / 100).toString());
            notInShopping.setMaxDeduct(WebUtil.formatAmount(activityBO.getMaxMoney() * 1.00 / 100).toString());
            activityList.add(notInShopping);
        }
        if (Objects.equals(ActivityTypeEnum.TYPE_12.getCode(), activityBO.getActivityType())) {
            int len = benefitBeanBOList.size();
            // // 购物车中无商品或者存在与满减互斥的活动
            for (int i = len - 1; i >= 0; i--) {
                benefitBeanBO = benefitBeanBOList.get(i);
                messageBuilder.append("满 <span style=\"color:#fa5555\">")
                        .append(WebUtil.formatAmount(benefitBeanBO.getThresholdAmount() * 1.00 / 100))
                        .append("</span> 减 <span style=\"color:#fa5555\">")
                        .append(WebUtil.formatAmount(benefitBeanBO.getDiscountAmount() * 1.00 / 100))
                        .append("</span> 元");
                if (i > 0) messageBuilder.append("，");
            }
            //  阶梯满减：满足 X 元 减 Y 元,
            for (int j = len - 1; j >= 0; j--) {
                benefitBeanBO = benefitBeanBOList.get(j);
                ActivityList notInShopping = new ActivityList();
                notInShopping.setTipType(2);
                notInShopping.setSatisfy(WebUtil.formatAmount(benefitBeanBO.getThresholdAmount() * 1.00 / 100).toString());
                notInShopping.setDeduct(WebUtil.formatAmount(benefitBeanBO.getDiscountAmount() * 1.00 / 100).toString());
                activityList.add(notInShopping);
            }
        }
        return activityList;
    }
    /**
     * 设置加入商品满足购物车时的提示语
     *
     * @param messageBuilder
     * @param activityPrompts
     * @param activityResponseDto
     */
    private List<ActivityList> setMessageSatisfyCart(StringBuilder messageBuilder, List<CalculationDiscountBO.CalculationDiscountResult.ActivityPrompt> activityPrompts
            , ActivityBO activityResponseDto) {
        ArrayList<ActivityList> result = new ArrayList<>();
        ActivityList satisfyList = new ActivityList();
        CalculationDiscountBO.CalculationDiscountResult.ActivityPrompt activityPrompt = activityPrompts.get(0);
        if (activityPrompt.getAlreadyDiscountAmount() == null
                || activityPrompt.getAlreadyDiscountAmount() == 0) {
            messageBuilder.append("满 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(activityPrompt.getThresholdAmount() * 1.00 / 100))
                    .append("</span> 减 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(activityPrompt.getDiscountAmout() * 1.00 / 100))
                    .append("</span> ")
                    .append("还差 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount((activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()) * 1.00 / 100))
                    .append("</span> 元");
            // 满足 X 元 减 Y 元 还差 Z元
            satisfyList.setTipType(3);
            satisfyList.setSatisfy(WebUtil.formatAmount(activityPrompt.getThresholdAmount() * 1.00 / 100).toString());
            satisfyList.setDeduct(WebUtil.formatAmount(activityPrompt.getDiscountAmout() * 1.00 / 100).toString());
            satisfyList.setMissing(WebUtil.formatAmount((activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()) * 1.00 / 100).toString());
        } else {
            Long toDiscountAmout;
            if (Objects.equals(ActivityTypeEnum.TYPE_11.getCode(), activityResponseDto.getActivityType())) {
                toDiscountAmout = activityPrompt.getDiscountAmout() + activityPrompt.getAlreadyDiscountAmount();
            } else {
                toDiscountAmout = activityPrompt.getDiscountAmout();
            }
            //已减 X 元 再买 Y 元 减 Z 元
            messageBuilder.append("已减 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(activityPrompt.getAlreadyDiscountAmount() * 1.00 / 100))
                    .append("</span> 元 再买 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount((activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()) * 1.00 / 100))
                    .append("</span> 元减 <span style=\"color:#fa5555\">")
                    .append(WebUtil.formatAmount(toDiscountAmout * 1.00 / 100))
                    .append("</span> 元");
            satisfyList.setTipType(4);
            satisfyList.setDeduct(WebUtil.formatAmount(activityPrompt.getAlreadyDiscountAmount() * 1.00 / 100).toString());
            satisfyList.setAgainBuy(WebUtil.formatAmount((activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()) * 1.00 / 100).toString());
            satisfyList.setAgianDeduct(WebUtil.formatAmount(toDiscountAmout * 1.00 / 100).toString());
        }
        result.add(satisfyList);
        return result;
    }


    /**
     * 设置加入商品不满足购物车时的提示语
     *
     * @param messageBuilder
     * @param discountList
     */
    private List<ActivityList> setMessageNoSatisfyCart(StringBuilder messageBuilder, List<CalculationDiscountBO.CalculationDiscountResult.Discount> discountList) {
        List<ActivityList> activityList = new ArrayList<>();
        discountList = discountList.parallelStream().filter(k -> (Objects.equals(ActivityTypeEnum.TYPE_11.getCode(), k.getType())
                || Objects.equals(ActivityTypeEnum.TYPE_12.getCode(), k.getType()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(discountList)) {
            return null;
        }
        //已减 X 元
        messageBuilder.append("已减 <span style=\"color:#fa5555\">")
                .append(WebUtil.formatAmount(discountList.get(0).getDiscount() * 1.00 / 100))
                .append("</span> 元");
        ActivityList noSatisfy = new ActivityList();
        noSatisfy.setTipType(5);
        noSatisfy.setDeduct(WebUtil.formatAmount(discountList.get(0).getDiscount() * 1.00 / 100).toString());
        activityList.add(noSatisfy);
        return activityList;
    }
}
