package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.GetStoreCloudPrintDto;
import cn.freemud.entities.dto.GetStoreCloudPrintResponseDto;
import cn.freemud.entities.dto.OrderPrintDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "MICRO-SUPPORT-SERVICE",url = "${saas.fmcloudprintclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface FMCloudPrintClient {

    /**
     * 获取门店打印机列表
     */
    @PostMapping(value = "/cloudPrint/getStorePrinter")
    GetStoreCloudPrintResponseDto getStoreCloudPrint(@RequestBody GetStoreCloudPrintDto getStoreCloudPrintDto);


    /**
     * 订单打印
     */
    @PostMapping(value = "/cloudPrint/asynchronous/print")
    BaseResponse orderPrint(@RequestBody OrderPrintDto orderPrintDto);


}
