package cn.freemud.client;

import cn.freemud.entities.dto.*;
//import cn.freemud.service.thirdparty.ShoppingCartClient;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ShoppingCartClientTest
 * @Package cn.freemud.client
 * @Description: 测试
 * @author: zhenghuan.yang
 * @date: 2018/6/25 14:50
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartClientTest {

//    @Autowired
//    private ShoppingCartClient shoppingCartClient;

    /**
     * 购物车添加商品
     */
//    @Test
//    public void addShoppingCart() {
//        AddShoppingCartRequestDto addShoppingCartRequestDto=new AddShoppingCartRequestDto();
//        addShoppingCartRequestDto.setMerchantId("2343242");
//        addShoppingCartRequestDto.setStoreId("1036");
//        addShoppingCartRequestDto.setUserId("wx001");
//        List<ShoppingCartProductDto> productslist=new ArrayList<ShoppingCartProductDto>();
//        ShoppingCartProductDto products=new ShoppingCartProductDto();
//        products.setId("pro001001");
//        products.setQty(1);
//        products.setSpecId("pro001");
//        List<ExtraProductDto> extraProductDtos = Lists.newArrayList();
//        ExtraProductDto extraProductDto = new ExtraProductDto();
//        extraProductDto.setId("pro001001");
//        extraProductDto.setQty(1);
//        extraProductDtos.add(extraProductDto);
//        extraProductDto = new ExtraProductDto();
//        extraProductDto.setId("pro001002");
//        extraProductDto.setQty(1);
//        extraProductDtos.add(extraProductDto);
//        extraProductDto = new ExtraProductDto();
//        extraProductDto.setId("pro001003");
//        extraProductDto.setQty(1);
//        extraProductDtos.add(extraProductDto);
//        products.setAddExtra(extraProductDtos);
//        productslist.add(products);
//        addShoppingCartRequestDto.setProducts(productslist);
//        ShoppingCartInfoDto response = shoppingCartClient.addShoppingCart(addShoppingCartRequestDto);
//        log.info("response==="+response);
//    }
//
//    /**
//     * 修改购物车商品数量
//     */
//    @Test
//    public void updateShoppingCart() {
//        UpdateShoppingCartRequestDto updateShoppingCartRequestDto=new UpdateShoppingCartRequestDto();
//        updateShoppingCartRequestDto.setCartProductId("110129854157947138");
//        updateShoppingCartRequestDto.setMerchantId("2343242");
//        updateShoppingCartRequestDto.setQty(0);
//        updateShoppingCartRequestDto.setStoreId("1036");
//        updateShoppingCartRequestDto.setUserId("m12321332423");
//        ShoppingCartBaseResponse shoppingCartBaseResponse = shoppingCartClient.updateShoppingCart(updateShoppingCartRequestDto);
//        log.info("shoppingCartBaseResponse==="+shoppingCartBaseResponse);
//    }
//    /**
//     * 查询购物商品
//     */
//    @Test
//    public void getShoppingCart(){
//        String storeId="fm001";
//        String userId="wx001";
//        String merChant_id="2343242";
//        GetShoppingCartDto getShoppingCartDto=new GetShoppingCartDto();
//        getShoppingCartDto.setUserId(userId);
//        getShoppingCartDto.setStoreId(storeId);
//        getShoppingCartDto.setMerchantId(merChant_id);
//        ShoppingCartInfoDto shoppingCartInfoDto=shoppingCartClient.getShoppingCart(getShoppingCartDto);
//        log.info("shoppingCartInfoDto==="+shoppingCartInfoDto);
//    }
//
//    /**
//     * 清空购物车
//     */
//    @Test
//    public void clearShoppingCart(){
//        ClearShoppingCartRequestDto clearShoppingCartRequestDto=new ClearShoppingCartRequestDto();
//        String storeId="fm001";
//        String userId="wx001";
//        String merChant_id="2343242";
//        clearShoppingCartRequestDto.setMerchantId(merChant_id);
//        clearShoppingCartRequestDto.setStoreId(storeId);
//        clearShoppingCartRequestDto.setUserId(userId);
//        ShoppingCartBaseResponse shoppingCartBaseResponse = shoppingCartClient.clearShoppingCart(clearShoppingCartRequestDto);
//        log.info("shoppingCartBaseResponse==="+shoppingCartBaseResponse);
//    }
//    /**
//     * 删除购物车一个商品
//     */
//    @Test
//    public void removeProduct(){
//        RemoveShoppingCartRequestDto removeShoppingCartRequestDto=new RemoveShoppingCartRequestDto();
//        removeShoppingCartRequestDto.setCartProductId("110129854157947138");
//        removeShoppingCartRequestDto.setMerchantId("2343242");
//        removeShoppingCartRequestDto.setStoreId("1036");
//        removeShoppingCartRequestDto.setUserId("wx001");
//        ShoppingCartBaseResponse shoppingCartBaseResponse= shoppingCartClient.removeProduct(removeShoppingCartRequestDto);
//        log.info("shoppingCartBaseResponse==="+shoppingCartBaseResponse);
//    }


}
