package com.freemud.sdk.api.assortment.order.enums;

public enum StoreDeliveryMethod {

    THIRD("1","third", "三方物流配送"),
    SELF("2","self", "商家自配送");
    private String type;
    private String code;
    private String desc;

    StoreDeliveryMethod(String type,String code,String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    static public String getCodeByType(String type) {
        String code = "";
        for (StoreDeliveryMethod value : StoreDeliveryMethod.values()) {
            if (value.getType().equals(type)) {
                code = value.getCode();
                break;
            }
        }
        return code;
    }

    public static StoreDeliveryMethod getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (StoreDeliveryMethod type : StoreDeliveryMethod.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
