/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: AfterSalesOrderResp
 * @Package com.freemud.application.sdk.api.ordercenter.response.orderInfo
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/11 15:35
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.response.orderInfo;

import lombok.Data;

import java.util.List;

@Data
public class AfterSalesOrderResp {

    /**
     * 实际金额，单位分
     */
    private Integer actualAmount;
    /**
     * 审核备注
     */
    private String adultRemark;
    /**
     * 售后单CODE
     */
    private String afterSalesCode;
    /**
     * 售后图片信息
     */
    private List<AfterSalesImages> afterSalesImages;
    /**
     * 售后单明细
     */
    private List<AfterSalesOrderItemResp> afterSalesOrderItems;
    /**
     * 申请原因
     */
    private String afterSalesReason;
    /**
     * 售后单状态 1:待处理 2:退货中 3:拒绝退款 4:已退货 5:完成 6:取消
     */
    private Integer afterSalesStatus;
    /**  售后单类型 1:其他取消 2:用户取消 3:商户取消 4:未支付超时关单 5:商户接单超时取消 6:商家拒单 7:配送用户拒收 */
    /**
     * 8:用户售后退货/售后退款 9:系统取消 10:客服取消 11:用户统一取消，相当于USER_CANCEL以及USER_SALE_RETURN包含的场景，内部会根据状态解析成具体类型
     * 13 门店主动取消
     */
    private Integer afterSalesType;
    /**
     * 创建时间
     */
    private String createTime;
    /**
     * 地址
     */
    private List<DeliveryContactInfoResp> deliveryContactInfo;
    /**
     * 配送渠道编号
     */
    private String expressChannelCode;
    /**
     * 配送渠道名称
     */
    private String expressChannelName;
    /**
     * 快递单号
     */
    private String expressNo;
    /**
     * 扩展字段
     */
    private String extInfo;
    /**
     * 是否有退货货物
     */
    private Boolean hasCargo;
    /**
     * 是否全部商品进行售后 0表示否 1表示是
     */
    private Boolean isAllItemAfterSales;
    /**
     * 操作者
     */
    private String operator;
    /**
     * 订单CODE
     */
    private String orderCode;
    /**
     * 订单服务无解释
     */
    private OrderInfoReqs orderInfo;
    /**
     * 退货发生的原始运费-上门费
     */
    private Integer originalShippingFee;
    /**
     * 商户号
     */
    private String partnerId;
    /**
     * 商户自己生成的退还申请号
     */
    private String partnerRefundCode;
    /**
     * 申请金额，单位分
     */
    private Integer reqAmount;
    /**
     * 申请说明
     */
    private String reqRemark;
    /**
     * 退货发生的结算运费-上门费结算
     */
    private Integer settlementShippingFee;
    /**
     * 第三方售后单号
     */
    private String thirdRefundCode;
    /**
     * 更新时间
     */
    private String updateTime;
    /**
     * 重量
     */
    private Integer weight;
    /**
     * 售后单阶段类型 1:售前 2:售中 3:售后
     */
    private Byte afterSalesStageType;

    /**
     * 门店ID
     */
    private String storeId;

}
