package cn.freemud.management.service.handle;

import cn.freemud.management.entities.dto.request.activity.GroupWorkRefundRequest;
import cn.freemud.management.entities.dto.response.activity.GroupWorkRefundResponse;
import cn.freemud.management.thirdparty.OMSActivityClient;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.sdk.api.assortment.order.domain.ResponseCodeConstant;
import org.springframework.stereotype.Component;

@Component
public class ActivityHandle {

    private final OMSActivityClient omsActivityClient;

    public ActivityHandle(OMSActivityClient omsActivityClient) {
        this.omsActivityClient = omsActivityClient;
    }

    public GroupWorkRefundResponse groupWorkRefund(OrderBeanV1 orderBean){
        GroupWorkRefundRequest groupWorkRefundRequest = new GroupWorkRefundRequest(orderBean.getSpellGroupActivityCode(),orderBean.getCompanyId(),orderBean.getSpellGroupCode(),orderBean.getOid(),orderBean.getUserId());
        GroupWorkRefundResponse groupWorkRefundResponse = omsActivityClient.groupWorkRefund(groupWorkRefundRequest);
        if (!ResponseCodeConstant.RESPONSE_SUCCESS.equals(groupWorkRefundResponse.getStatusCode())) {
            return null;
        }
        return groupWorkRefundResponse;
    }
}
