package cn.freemud.service.impl;

import cn.freemud.adapter.DeliveryAdapter;
import cn.freemud.adapter.LightApplicationConvertToAssortmentSdkAdapter;
import cn.freemud.adapter.OrderAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.util.DateUtil;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.bo.CreateOrderBONew;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.blacklist.BlacklistDto;
import cn.freemud.entities.dto.ecology.VirtualBindStoreResponse;
import cn.freemud.entities.dto.ecology.VirtualStoreRequest;
import cn.freemud.entities.dto.order.CreateOrderOperateDto;
import cn.freemud.entities.dto.order.CreatePrepayRequestDto;
import cn.freemud.entities.dto.product.AttributeValue;
import cn.freemud.entities.dto.product.GroupDetail;
import cn.freemud.entities.dto.product.ProductAttributeGroup;
import cn.freemud.entities.dto.product.ProductGroup;
import cn.freemud.entities.dto.promotion.GroupWorkJoinResponse;
import cn.freemud.entities.dto.shoppingCart.NewShoppingCartClearDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.dto.wechat.GetAuthorizerRequestDto;
import cn.freemud.entities.dto.wechat.GetTokenResponseDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.*;
import cn.freemud.handler.MemberBlacklistHandler;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.request.pay.PayRefundRequestDto;
import cn.freemud.management.entities.dto.response.pay.OrderRefundResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.manager.SpellGroupOrderDataManager;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.BuriedPointService;
import cn.freemud.service.CouponActivityService;
import cn.freemud.service.MallOrderService;
import cn.freemud.service.business.OrderBusinessService;
import cn.freemud.service.thirdparty.EcologyAdminApplicationClient;
import cn.freemud.service.thirdparty.ShoppingCartClient;
import cn.freemud.utils.AppLogUtil;
import cn.freemud.utils.RedisUtil;
import cn.freemud.utils.ResponseUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformWxappManager;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.application.sdk.api.constant.ResponseConstant;
import com.freemud.application.sdk.api.deliverycenter.dto.ArriveDeliveryRequestDto;
import com.freemud.application.sdk.api.deliverycenter.dto.CreateDeliveryOrderRequestDto;
import com.freemud.application.sdk.api.deliverycenter.response.CreateDeliveryOrderResponseDto;
import com.freemud.application.sdk.api.deliverycenter.response.DeliveryInfoDto;
import com.freemud.application.sdk.api.deliverycenter.response.DeliveryResponseDto;
import com.freemud.application.sdk.api.deliverycenter.service.DeliveryService;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.*;
import com.freemud.application.sdk.api.ordercenter.request.OrderChangeStateReq;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.ordercenter.request.POSOrderOperationBaseReq;
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.AfterSalesOrderResp;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter;
import com.freemud.sdk.api.assortment.order.enums.OperationClientEnum;
import com.freemud.sdk.api.assortment.order.enums.QueryOrderAccountType;
import com.freemud.sdk.api.assortment.order.request.order.*;
import com.freemud.sdk.api.assortment.order.response.order.BaseOrderResponse;
import com.freemud.sdk.api.assortment.order.response.order.CreateOrderResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryRelatedOrderByCodeResp;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import com.freemud.sdk.api.assortment.order.vo.ProductGroupVo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
public class MallOrderServiceImpl implements MallOrderService {

    private final Integer RESPONSE_SUCCESS_CODE = 100;

    private static Gson gson = new Gson();

    @Value("${saas.reverseNotifyiDcUrl}")
    private String reverseNotifyiDcUrl;

    @Value("${saas.delivery.mall.callback.notifyUrl}")
    private String deliveryNotifyUrl;

    @Autowired
    private CheckMallOrder checkMallOrder;
    @Autowired
    private CheckOrder checkOrder;
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private AssortmentOpenPlatformWxappManager openPlatformWxappManager;
    @Autowired
    private OrderAdapter orderAdapter;
    @Autowired
    private ItemServiceImpl itemService;
    @Autowired
    private ShoppingCartClient shoppingCartClient;
    @Autowired
    private BuriedPointService buriedPointService;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private DeliveryAdapter deliveryAdapter;
    @Autowired
    private DeliveryService deliveryService;
    @Autowired
    private OrderSdkService orderSdkService;
    @Autowired
    private EcologyAdminApplicationClient ecologyAdminApplicationClient;
    @Autowired
    private OrderSdkAdapter orderSdkAdapter;

    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;

    @Autowired
    private CouponActivityService couponActivityService;

    @Autowired
    private AssortmentCustomerInfoManager assortmentCustomerInfoManager;
    @Autowired
    private PaymentQueueService paymentQueueService;
    @Autowired
    private OrderBusinessService orderBusinessService;
    @Autowired
    private OrderQueueService orderQueueService;
    @Autowired
    private PayServiceImpl payServiceImpl;

    @Autowired
    private SpellGroupOrderDataManager spellGroupOrderDataManager;

    @Autowired
    private MemberBlacklistHandler memberBlacklistHandler;

    /**
     * 创建订单
     */
    @Override
    public BaseResponse createOrder(CreateOrderBONew createOrderBO) {
        CreateOrderVo createOrderVo = createOrderBO.getCreateOrderVo();

        String trackingNo = LogThreadLocal.getTrackingNo();
        // 查询用户信息、校验svc卡,余额购物车校验
        AssortmentCustomerInfoVo userLoginInfoDto = checkMallOrder.checkOrderByMember(createOrderVo);
        // 设置门店id为商城的虚拟门店id
        this.change2BindMallShopId(createOrderVo, userLoginInfoDto.getWxAppId());
        // 查询门店信息 营业时间、营业状态，服务器当前时间在营业时间内 点餐桌号
        StoreResponseDto storeResponseDto = checkMallOrder.checkOrderByStore(createOrderVo, trackingNo);
        // 查询购物车（内部校验券点餐方式，券是否可用） 校验当前订单类型的下单参数
        ShoppingCartGoodsDto shoppingCartGoodsDto = checkMallOrder.getShoppingCartGoodsDto(createOrderVo);
        // 查询商城的配送模板信息，校验订单是否满足配送条件
        checkMallOrder.checkOrderByDelivery(createOrderVo, userLoginInfoDto, storeResponseDto, shoppingCartGoodsDto.getTotalAmount(), trackingNo);
        OrderExtInfoDto extInfo = this.getExtInfo(userLoginInfoDto, storeResponseDto, createOrderVo);
        BaseResponse response = this.createOrderFlow(createOrderVo, storeResponseDto, shoppingCartGoodsDto, userLoginInfoDto, extInfo);
        if (!Objects.equals(response.getCode(), ResponseResult.SUCCESS.getCode())) {
            return response;
        }
        //组装支付公共方法参数
        CreateOrderOperateDto createOrderOperateDto = (CreateOrderOperateDto) response.getResult();
        createOrderBO.setExtInfo(extInfo);
        //创建支付
        CreatePrepayRequestDto createPrepayRequestDto = orderAdapter.convertToCreatePrepayRequestDto(createOrderBO, createOrderOperateDto);
        return ResponseUtil.success(payServiceImpl.createPrepayOrder(createPrepayRequestDto));
    }

    /**
     * 订单确认完成
     */
    @Override
    @Deprecated
    public BaseResponse orderAffirm(OrderAffirmRequestVO requestVO) {
        String trackingNo = LogThreadLocal.getTrackingNo();

        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(requestVO.getOid());
        baseQueryOrderRequest.setTrackingNo(trackingNo);
        QueryOrderByIdResponse response = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        // 判断订单信息是否存在
        BaseResponse baseResponse = this.checkOrder(response, requestVO.getPartnerId());
        if (baseResponse != null) {
            return baseResponse;
        }
        OrderBeanV1 orderBean = response.getData();
        //判断订单是否已经完成
        if (NewOrderStatus.COMPLETE.getIndex().equals(orderBean.getStatusV2())) {
            return ResponseUtil.error(ResponseResult.ORDER_REPEAT_DO_COMPLETE);
        }
        //已取消的订单不能操作
        if (NewOrderStatus.CLOSED.getIndex().equals(orderBean.getStatusV2())) {
            return ResponseUtil.error(ResponseResult.ORDER_HAS_CANCELED);
        }
        //非商城订单不允许操作
        if(BizTypeEnum.MALL.getBizType() != orderBean.getBizType()) {
            return ResponseUtil.error(ResponseResult.ORDER_MALL_NOT_MATCH);
        }

        /**
         * 修改配送状态
         */
        if(orderBean.getAddInfo() != null && StringUtils.isNotEmpty(orderBean.getAddInfo().getDeliveryId())) {
            UpdateDeliveryInfoByIdRequest updateDeliveryInfoByIdRequest = new UpdateDeliveryInfoByIdRequest();
            updateDeliveryInfoByIdRequest.setOrderId(orderBean.getOid());
            updateDeliveryInfoByIdRequest.setOrderSubState(DeliveryStatus.DELIVERYARRIVED.getCode());
            updateDeliveryInfoByIdRequest.setBizType(BizTypeEnum.MALL.getBizType());
            updateDeliveryInfoByIdRequest.setPartnerId(orderBean.getCompanyId());
            orderCenterSdkService.updateDeliveryInfoById(updateDeliveryInfoByIdRequest);
        }

        /**
         * 配送完成
         */
        POSOrderOperationBaseReq prepareCompleteDeliveryReq = new POSOrderOperationBaseReq();
        prepareCompleteDeliveryReq.setOrderCode(orderBean.getOid());
        prepareCompleteDeliveryReq.setPartnerId(orderBean.getCompanyId());
        orderSdkService.prepareCompleteDelivery(prepareCompleteDeliveryReq, trackingNo);

        /**
         * 调用物流运单完成
         */
        if(orderBean.getAddInfo() != null && StringUtils.isNotEmpty(orderBean.getAddInfo().getDeliveryId())) {
            ArriveDeliveryRequestDto arriveDeliveryRequestDto = new ArriveDeliveryRequestDto();
            arriveDeliveryRequestDto.setDeliveryId(orderBean.getAddInfo().getDeliveryId());
            deliveryService.deliveryFinish(arriveDeliveryRequestDto, trackingNo);
        }

        return ResponseUtil.success();
    }


    private void change2BindMallShopId(CreateOrderVo createOrderVo, String wxAppId) {
        VirtualStoreRequest virtualStoreRequest = new VirtualStoreRequest();
        virtualStoreRequest.setPlatformAppId(wxAppId);
        virtualStoreRequest.setType("microMall");
        BaseResponse<VirtualBindStoreResponse> virtualBindStoreResponse = ecologyAdminApplicationClient.getBuyBindVirtualStore(virtualStoreRequest);
        if(virtualBindStoreResponse == null || virtualBindStoreResponse.getResult() == null || StringUtils.isBlank(virtualBindStoreResponse.getResult().getStoreId())) {
            throw new ServiceException(ResponseResult.STORE_BIND_MALL_NOT_FOUND);
        }
        createOrderVo.setShopId(virtualBindStoreResponse.getResult().getStoreId());
    }

    private OrderExtInfoDto getExtInfo(AssortmentCustomerInfoVo userLoginInfoDto, StoreResponseDto storeResponseDto, CreateOrderVo createOrderVo) {
        String sessionId = createOrderVo.getSessionId();
        String version = createOrderVo.getVersion();

        OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
        orderExtInfoDto.setOpenid(userLoginInfoDto.getOpenId());
        orderExtInfoDto.setAppid(userLoginInfoDto.getWxAppId());
        orderExtInfoDto.setSessionId(sessionId);
        orderExtInfoDto.setVersion(version);
        orderExtInfoDto.setProvince(createOrderVo.getProvince());
        return orderExtInfoDto;
    }

    private BaseResponse createOrderFlow(CreateOrderVo createOrderVo, StoreResponseDto storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto, AssortmentCustomerInfoVo userLoginInfoDto, OrderExtInfoDto orderExtInfoDTO) {
        OrderExtendedReq orderExtendedReq = orderAdapter.saveStoreInfo(storeResponseDto);
        //创建普通订单
        Function<Object, CreateOrderResponse> createOrder = (var -> {
            BaseCreateOrderRequest baseCreateOrderRequest = orderAdapter.convent2CreateOrderDto(createOrderVo, shoppingCartGoodsDto,storeResponseDto);
            //查询第三方商品编号
            baseCreateOrderRequest = getProductCustomerCode(baseCreateOrderRequest);
            //保存门店渠道信息
            baseCreateOrderRequest.setOrderExtended(orderExtendedReq);
            baseCreateOrderRequest.setMarketingType(MarketTypeEnum.ORDER.getIndex().byteValue());
            baseCreateOrderRequest.setBizType(BizTypeEnum.MALL.getBizType());
            OrderClientType orderClient = OrderClientType.SAAS;
            if (ChannelEnum.TYPE_2.getCode().equals(userLoginInfoDto.getChannel())) {
                orderClient = OrderClientType.ALIPAY;
            }
            baseCreateOrderRequest.setOrderClient(orderClient);
            CreateOrderRequest createOrderRequest = new CreateOrderRequest();
            baseCreateOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
            createOrderRequest.setBaseCreateOrderRequest(baseCreateOrderRequest);
            createOrderRequest.getBaseCreateOrderRequest().setUserName(userLoginInfoDto.getNickName());
            createOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());

            // fisherman -> 微商城消费黑名单限制

            BlacklistDto blacklistDto = new BlacklistDto();
            blacklistDto.setAmount(baseCreateOrderRequest.getAmount());
            blacklistDto.setPartnerId(createOrderVo.getPartnerId());
            blacklistDto.setMemberId(createOrderVo.getUserId());
            if (CollectionUtils.isNotEmpty(baseCreateOrderRequest.getAccounts())) {
                // 过滤出券, 黑名单有用户不能用券
                List<CreateOrderAccountRequest> useAccount = baseCreateOrderRequest.getAccounts()
                        .stream()
                        .filter(a -> QueryOrderAccountType.useCouponList.contains(a.getAccountType()))
                        .collect(Collectors.toList());
                blacklistDto.setUseCoupon(CollectionUtils.isNotEmpty(useAccount));
            }
            blacklistDto.setUseCustomerScore(createOrderVo.getUseCustomerScore());
            String touchStr = memberBlacklistHandler.checkisTrueBlacklist(blacklistDto);
            if (StringUtils.isNotEmpty(touchStr)) {
                CreateOrderResponse baseOrderResponse = new CreateOrderResponse();
                baseOrderResponse.setErrcode(Integer.valueOf(ResponseResult.TOUCH_SHOPPING_BLACK_LIST.getCode()));
                baseOrderResponse.setErrmsg(touchStr);
                baseOrderResponse.setData(null);
                return baseOrderResponse;
            }

            return orderBusinessService.createOrderFlow(createOrderRequest);
        });

        //普通订单
        CreateOrderResponse createOrderFlowResponse = createOrder.apply(null);
        if (ObjectUtils.notEqual(Integer.valueOf(ResponseResult.SUCCESS.getCode()), createOrderFlowResponse.getErrcode())) {
            return ResponseUtil.error(createOrderFlowResponse.getErrcode().toString(), createOrderFlowResponse.getErrmsg());
        }
        OrderBeanV1 orderBean = createOrderFlowResponse.getData();
        long totalAmount = orderBean.getAmount();

        CreateOrderOperateDto response = new CreateOrderOperateDto();
        response.setTotalAmount(totalAmount);
        response.setFatherOrderBean(orderBean);
        response.setProductOrderBean(orderBean);
        return ResponseUtil.success(response);
    }

//    private PaymentRequest orderBodyConvertToPaymentBody(AssortmentCustomerInfoVo userLoginInfoDto, String partnerId) {
//        String wxAppId = userLoginInfoDto.getWxAppId();
//        //设置支付信息
//        PaymentRequest paymentRequest = new PaymentRequest();
//        paymentRequest.setOpenId(userLoginInfoDto.getOpenId());
//        paymentRequest.setWxAppId(wxAppId);
//        AssortmentOpenPlatformWxapp wxApp = openPlatformWxappManager.findByPartnerIdAndWxappId(partnerId, wxAppId);
//        paymentRequest.setPrincipalName(StringUtils.defaultString(wxApp.getPrincipalName(), "上海非码网络科技有限公司"));
//        paymentRequest.setReverseNotifyiDcUrl(reverseNotifyiDcUrl);
//        return paymentRequest;
//    }

//    private OrderPayResponse getOrderPayResponse(PaymentRequest paymentRequest, OrderBeanV1 orderBean) {
//        OrderPayResponse orderPayResponse;
//        String fmId = "SPAY" + ValidationCode.getRandomUuid();
//        orderPayResponse = orderAdapter.getOrderPayResponse(orderBean.getCompanyId(), paymentRequest,
//                orderBean.getOid(), fmId);
//        return orderPayResponse;
//    }

//    private BaseResponse failPreOrderPay(String trackingNo, OrderBeanV1 orderBean, String cardCode) {
//        //失败冲正库存，冲正活动库存，取消订单
//        CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(), orderBean.getCompanyId(),
//                AfterSalesType.SYSTEM_CANCEL, "获取预支付失败", trackingNo, null);
//        orderCenterSdkService.orderCancel(cancelOrderRequest);
//        return ResponseUtil.error(ResponseResultEnum.PAY_UNIFIED_ORDER_ERROR.getCode(), ResponseResultEnum.PAY_UNIFIED_ORDER_ERROR.getMessage(), null);
//    }

//    public OrderPayResponse getPreOrderPay(OrderBeanV1 orderBean, PaymentRequest paymentRequest, String trackingNo, Integer cardAmount) {
//        try {
//            OrderPayResponse orderPayResponse;
//            UnifiedOrderRequest request = orderAdapter.convent2UnifiedOrderRequest(orderBean, paymentRequest, orderBean.getAmount(), cardAmount, orderBean.getOid());
//            com.freemud.application.sdk.api.base.BaseResponse<UnifiedOrderResponse> responseBase = payServiceImpl.unifiedOrder(request);
//            if (!ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(responseBase.getCode())) {
//                // 1.9.34 预支付失败需要把原因进行记录
//                orderPayResponse = new OrderPayResponse();
//                orderPayResponse.setMsg(responseBase.getMessage());
//                return orderPayResponse;
//            }
//            orderPayResponse = orderAdapter.convent2OrderPayResponse(responseBase.getData());
//            orderPayResponse.setWxAppid(paymentRequest.getWxAppId());
//            orderPayResponse.setOpenId(paymentRequest.getOpenId());
//            orderPayResponse.setPartnerId(orderBean.getCompanyId());
//            orderPayResponse.setOrderId(orderBean.getOid());
//            orderPayResponse.setPayChannelType(PayChannelType.WECHAT);
//            if (orderPayResponse.getPayOrder() != null && StringUtils.isNotBlank(orderPayResponse.getPayOrder().getAliPayOrder())
//                    && !orderPayResponse.getPayOrder().getAliPayOrder().startsWith("wx")) {
//                orderPayResponse.setPayChannelType(PayChannelType.ALIPAY);
//            }
//            putDelMq(request.getPartnerId(), request.getStoreId(), responseBase.getData().getFmId(), orderBean.getOid());
//            return orderPayResponse;
//        } catch (Exception e) {
//            AppLogUtil.errorLog("getPreOrderPay_error", JSONObject.toJSONString(orderBean), JSONObject.toJSONString(paymentRequest),e);
//            //TODO 邮件告警
//            return null;
//        }
//    }

    /**
     * 编辑订单，保持预支付信息
     */
//    public BaseResponse updateOrderInfo(OrderPayResponse orderPayResponse, OrderExtInfoDto orderExtInfo
//            , OrderBeanV1 orderBean, String trackingNo) {
////        orderExtInfo = orderAdapter.getOrderExtInfo(orderPayResponse, orderExtInfo);
//        orderExtInfo.setOpenid(orderPayResponse.getOpenId());
//        String prepayId = "";
//        // StringUtils 依赖修改
//        if (orderPayResponse.getPayOrder() != null && !StringUtils.isEmpty(orderPayResponse.getPayOrder().getPackageX())) {
//            String[] prepayIds = orderPayResponse.getPayOrder().getPackageX().split("=");
//            prepayId = prepayIds.length > 1 ? prepayIds[1] : "";
//        }
//        orderExtInfo.setPrepayId(prepayId);
//
//        OrderEditRequest orderEditRequest = new OrderEditRequest(orderPayResponse.getPayTransId(),
//                JSONObject.toJSONString(orderExtInfo));
//        orderEditRequest.setOrderId(orderBean.getOid());
//        orderEditRequest.setTrackingNo(trackingNo);
//        if (orderPayResponse.getPayChannelType() != null) {
//            orderEditRequest.setPayChannel(orderPayResponse.getPayChannelType().getEbcode());
//            orderEditRequest.setPayChannelName(orderPayResponse.getPayChannelType().getName());
//            orderEditRequest.setPayChannelType(orderPayResponse.getPayChannelType().getIndex());
//        }
//        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderEdit(orderEditRequest);
//        if (!ObjectUtils.equals(ResponseCodeConstant.RESPONSE_SUCCESS, baseOrderResponse.getErrcode())) {
//            CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(), orderBean.getCompanyId(),
//                    AfterSalesType.SYSTEM_CANCEL, "编辑订单支付信息失败", trackingNo, null);
//            orderCenterSdkService.orderCancel(cancelOrderRequest);
//            return ResponseUtil.error(baseOrderResponse.getErrcode().toString(), baseOrderResponse.getErrmsg());
//        }
//
//        return null;
//    }

//    public String paySuccessCallback(PaysuccessNoticeMessage message) {
//        ConfirmOrderDto confirmOrderDto = orderAdapter.convent2ConfirmOrderDto(message);
//        Map<String, OrderBeanV1> orderBeans = getOrderBeanByOrderId(confirmOrderDto.getOrderId());
//        return this.paySuccessCallback(message, confirmOrderDto, orderBeans);
//    }





    @Override
    public String paySuccessCallback(PaysuccessNoticeMessage message, ConfirmOrderDto confirmOrderDto, Map<String, OrderBeanV1> orderBeans) {
        OrderBeanV1 orderBean = orderBeans.get(OrderBeanType.SAASORDER.getCode());

        String partnerId = orderBean.getCompanyId();
        String userId = orderBean.getUserId();
        String storeId = orderBean.getShopId();
        orderBean.setPayVoucher(message.getOut_trade_no());
        //编辑订单信息，获取openid，用于退款
        String extInfo = orderBean.getExtInfo();
        OrderExtInfoDto orderExtInfoDto = null;
        String wxappid = "";
        String sessionId = "";
        if (StringUtils.isNotBlank(extInfo)) {
            orderExtInfoDto = gson.fromJson(extInfo, OrderExtInfoDto.class);
            if (orderExtInfoDto != null) {
                wxappid = orderExtInfoDto.getAppid();
                sessionId = orderExtInfoDto.getSessionId();
            }
        }
        // 如果订单状态不是未支付，返回信息
        if (!PayStatus.NOT_PAY.getCode().equals(orderBean.getPayStatus()) || !NewOrderStatus.PENDING_PAYMENT.getIndex().equals(orderBean.getStatusV2())) {
            return sendPaySuccessNoticeMessage();
        }

        // 订单失败后 发消息重试 待实现
        PayAccessResponse payAccessResponse;
        ConfirmOrderRequest confirmOrderRequest = LightApplicationConvertToAssortmentSdkAdapter.confirmOrderDtoConvertToConfirmOrderRequest(confirmOrderDto, null);
        confirmOrderRequest.setPartnerId(partnerId);
        confirmOrderRequest.setUserId(userId);
        confirmOrderRequest.setStoreId(storeId);
        confirmOrderRequest.setOrderId(orderBean.getOid());
        confirmOrderRequest.setOrderType(orderBean.getOrderType());
        confirmOrderRequest.setProductOrderCode(orderBean.getOid());
        confirmOrderRequest.setExtInfo(orderBean.getExtInfo());

        List<String> orderIds = new ArrayList<>();
        //拼单调促销开团
        if(MarketTypeEnum.GROUPB.getIndex().byteValue() == orderBean.getMarketingType()){
            AssortmentCustomerInfoVo userLoginInfoDto = customerInfoManager.getCustomerInfoByObject(sessionId);
            GroupWorkJoinResponse groupWorkJoinResponse = spellGroupOrderDataManager.groupWorkJoin(orderBean,userLoginInfoDto,wxappid);
            if(!ResponseResult.SUCCESS.getCode().equals(groupWorkJoinResponse.getStatusCode()) || groupWorkJoinResponse.getResult() == null){
                // fisherman 如果响应码是800 表示订单重复参与-> 有可能是因为支付回调了两次接口 直接返回成功
                if ("800".equals(groupWorkJoinResponse.getStatusCode())) {
                    return gson.toJson(message);
                }
                orderRefund(orderBean, groupWorkJoinResponse.getMsg());
                orderQueueService.backOrdersStatusChange(orderBean.getOid(),orderBean.getStatus());
                return gson.toJson(message);
            }

            if("2".equals(groupWorkJoinResponse.getResult().getGroupStatus())){
                orderRefund(orderBean, "成团失败,退款流程");
                orderQueueService.backOrdersStatusChange(orderBean.getOid(),orderBean.getStatus());
                return gson.toJson(message);
            }
            if(StringUtils.isEmpty(orderBean.getSpellGroupCode())){
                confirmOrderRequest.setSpellGroupCode(groupWorkJoinResponse.getResult().getGroupId());
            }
            //表示已成团，团下面订单全部接单
            if("1".equals(groupWorkJoinResponse.getResult().getGroupStatus())){
                orderIds = groupWorkJoinResponse.getResult().getOrderIds();
            }

        }
        // 订单支付成功
        com.freemud.sdk.api.assortment.order.response.order.PayAccessResponse payAccessRes = orderBusinessService.payAccess(confirmOrderRequest);
        String string2 = JSONObject.toJSONString(payAccessRes);
        JSONObject jsonObject2 = JSONObject.parseObject(string2);
        payAccessResponse = jsonObject2.toJavaObject(PayAccessResponse.class);
        // 添加幂等处理，若订单是已支付成功状态，直接返回成功
        if (!RESPONSE_SUCCESS_CODE.equals(payAccessResponse.getErrcode())) {
            OrderBeanV1 saasOrder = getOrderBeanByOrderId(confirmOrderDto.getOrderId()).get(OrderBeanType.SAASORDER.getCode());
            if (saasOrder != null && (!PayStatus.NOT_PAY.getCode().equals(saasOrder.getPayStatus()) || !NewOrderStatus.PENDING_PAYMENT.getIndex().equals(saasOrder.getStatusV2()))) {
                return sendPaySuccessNoticeMessage();
            }
            return gson.toJson(message);
        }

        // 订单扩展信息
        if (orderExtInfoDto != null) {
            orderExtInfoDto.setPayDate(DateUtil.convert2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            orderExtInfoDto.setPayTransId(message.getOut_trade_no());
            OrderEditDto orderEditDto = new OrderEditDto(orderBean.getOid(), gson.toJson(orderExtInfoDto));
            OrderEditRequest orderEditRequest = new OrderEditRequest(orderEditDto.getOrderId(), orderEditDto.getExtInfo(), orderBean.getCompanyId());
            orderEditRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
            orderCenterSdkService.orderEdit(orderEditRequest);
        }

        // 清空购物车
        NewShoppingCartClearDto newShoppingCartClearDto = new NewShoppingCartClearDto();
        newShoppingCartClearDto.setPartnerId(partnerId);
        newShoppingCartClearDto.setShopId(storeId);
        newShoppingCartClearDto.setUserId(userId);
        newShoppingCartClearDto.setAppId(wxappid);
        newShoppingCartClearDto.setSessionId(sessionId);
        newShoppingCartClearDto.setOperationType(1);
        newShoppingCartClearDto.setChannelType(OrderChannelType.SAASMALL.getCode());
        shoppingCartClient.clearShoppingCart(newShoppingCartClearDto);

        //支付回掉成功标记
        redisCache.save(RedisKeyConstant.KGD_PAYMENT_CALLBACK_FMID + message.getOut_trade_no(), message.getOut_trade_no(), 10L, TimeUnit.MINUTES);
        if (message.getSource() != null && message.getSource().equals(PaySuccessSource.OUTSIDE.getSource())) {
            verificationCoupon(message.getTrans_id(), message.getThirdPartTradeNo());
        }

        orderIds.add(orderBean.getOid());
        orderIds = orderIds.stream().distinct().collect(Collectors.toList());
        //接单
        if(orderIds.size() > 1 || orderBean.getMarketingType() != MarketTypeEnum.GROUPB.getIndex().byteValue()){
            POSOrderOperationBaseReq acceptOrderReq = new POSOrderOperationBaseReq();
            for(String orderId : orderIds){
                acceptOrderReq.setOrderCode(orderId);
                acceptOrderReq.setPartnerId(partnerId);
                try {
                    OrderBaseResp baseResponse = orderSdkService.acceptOrder(acceptOrderReq, LogThreadLocal.getTrackingNo());
                    if(baseResponse == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(baseResponse.getCode())) {
                        AppLogUtil.infoLog("paySuccessCallback_acceptOrder_faild", gson.toJson(confirmOrderDto), gson.toJson(payAccessResponse));
                    }
                }catch (Exception e){
                    AppLogUtil.errorLog("paySuccessCallback_acceptOrder_error",orderId,null,e);
                }
            }
        }
        return sendPaySuccessNoticeMessage();
    }

    private Map<String, OrderBeanV1> getOrderBeanByOrderId(String orderId) {
        // 订单查询：若结果集只有一个orderBean，则为普通订单，否则为会员卡订单（父子订单）
        Map<String, OrderBeanV1> result = new HashMap<>();
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = getQueryRelationOrderByIdResponseDto(orderId);
        if (CollectionUtils.isEmpty(queryOrderByIdResponseDto.getData())) {
            return result;
        }
        if (1 == queryOrderByIdResponseDto.getData().size()) {
            result.put(OrderBeanType.SAASORDER.getCode(), queryOrderByIdResponseDto.getData().get(0));
        } else {
            List<OrderBeanV1> saasOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(1)).collect(Collectors.toList());
            List<OrderBeanV1> memberOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(3) && !order.getIsParent()).collect(Collectors.toList());
            List<OrderBeanV1> fatherOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(2) && order.getIsParent()).collect(Collectors.toList());
            result.put(OrderBeanType.SAASORDER.getCode(), CollectionUtils.isNotEmpty(saasOrderBeans) ? saasOrderBeans.get(0) : null);
            result.put(OrderBeanType.MERMBERORDER.getCode(), CollectionUtils.isNotEmpty(memberOrderBeans) ? memberOrderBeans.get(0) : null);
            result.put(OrderBeanType.FATHERORDER.getCode(), CollectionUtils.isNotEmpty(fatherOrderBeans) ? fatherOrderBeans.get(0) : null);
        }
        return result;
    }

    /**
     * 获取商品第三方商品编号
     *
     * @param createOrderDto
     * @return
     */
    private BaseCreateOrderRequest getProductCustomerCode(BaseCreateOrderRequest createOrderDto) {
        List<String> spuIds = new ArrayList<>();
        for (CreateOrderProductRequest productDto : createOrderDto.getProducts()) {
            spuIds.add(productDto.getProductId());
        }
        Map<String, GetProductsVo> products = itemService.getSpuProducts(spuIds, createOrderDto.getCompanyId(), createOrderDto.getShopId(),createOrderDto.getMenuType());
        if (products.isEmpty()) {
            return createOrderDto;
        }
        for (CreateOrderProductRequest productDto : createOrderDto.getProducts()) {
            String skuId = productDto.getSpecification();
            if (products.get(skuId) != null) {
                productDto.setCustomerCode(products.get(skuId).getCustomerCode());
                productDto.setProductCode(products.get(skuId).getProductCode());
                productDto.setThirdProductSpecId(products.get(productDto.getSpecification()).getThirdProductSpecId());
                productDto.setThirdProductPropertyId(getThirdPropertyId(products.get(productDto.getSpecification()).getProductAttributeGroupList(),productDto.getAddInfo()));

                // todo 商品组信息
                setProductGroupInfo(products.get(skuId).getProductGroupList(), productDto);
            } else {
                productDto.setCustomerCode("");
                productDto.setProductCode("");
                AppLogUtil.errorLog("getProducts_exception", JSONObject.toJSONString(skuId), JSONObject.toJSONString(products), null);
            }
            //套餐子商品
            if(CollectionUtils.isNotEmpty(productDto.getComboProduct())){
                for (CreateOrderProductRequest comboProduct : productDto.getComboProduct()){
                    String comboSkuId = comboProduct.getSpecification();
                    if (products.get(comboSkuId) != null) {
                        comboProduct.setCustomerCode(products.get(comboSkuId).getCustomerCode());
                        comboProduct.setProductCode(products.get(comboSkuId).getProductCode());
                        comboProduct.setThirdProductSpecId(products.get(comboSkuId).getThirdProductSpecId());
                        comboProduct.setThirdProductPropertyId(getThirdPropertyId(products.get(comboSkuId).getProductAttributeGroupList(),comboProduct.getAddInfo()));
                        comboProduct.setStapleFood(products.get(comboSkuId).getStapleFood());
                        // todo 套餐商品的商品组信息
                        setProductGroupInfo(products.get(comboSkuId).getProductGroupList(), comboProduct);
                    } else {
                        comboProduct.setCustomerCode("");
                        comboProduct.setProductCode("");
                        AppLogUtil.errorLog("getProducts_exception", JSONObject.toJSONString(skuId), JSONObject.toJSONString(products), null);
                    }
                }
            }
        }
        return createOrderDto;
    }

    private QueryRelationOrderByIdResponseDto getQueryRelationOrderByIdResponseDto(String oid) {
        QueryRelatedOrderByCodeRequest baseQueryOrderRequest = new QueryRelatedOrderByCodeRequest();
        baseQueryOrderRequest.setOrderCode(oid);
        baseQueryOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
        QueryRelatedOrderByCodeResp queryOrderByIdResponse;
        queryOrderByIdResponse = orderCenterSdkService.queryRelatedOrderByCode(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = jsonObject.toJavaObject(QueryRelationOrderByIdResponseDto.class);
        String orderString = JSONObject.toJSONString(queryOrderByIdResponse.getOrderBeanList());
        queryOrderByIdResponseDto.setData(JSONArray.parseArray(orderString, OrderBeanV1.class));
        return queryOrderByIdResponseDto;
    }

    /**
     * 支付后通知确认返回信息
     */
    public String sendPaySuccessNoticeMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 0);
        map.put("message", "success");
        return gson.toJson(map);
    }

    /**
     * 异常状态退款流程
     */
    public void orderRefund(OrderBeanV1 orderBean, String refundReason) {
        OrderRefundVo orderRefundVo = new OrderRefundVo();
        orderRefundVo.setOid(orderBean.getOid());
        orderRefundVo.setPartnerId(orderBean.getCompanyId());
        orderRefundVo.setReason(refundReason);
        partnerNoTakeOrder(orderRefundVo, orderBean, orderBean.getOid());
    }

    /**
     * 商家未接单,取消订单逻辑处理    1.调用支付退款 2.根据支付退款返回状态组装订单取消参数,调用订单取消接口
     *
     * @param orderRefundVo
     * @param orderBean
     */
    private BaseResponse partnerNoTakeOrder(OrderRefundVo orderRefundVo, OrderBeanV1 orderBean, String fatherOrderId) {
//        PayRefundResponse response = null;
        Long refundId = System.currentTimeMillis();
        String partnerId = orderBean.getCompanyId();
        int state = PayRefundStatus.SUCCESS.getCode();
        if (orderBean.getAmount() != 0) {
            //调用支付退款
//            PayRefundRequestDto orderPayRefundRequest = orderAdapter.getOrderPayRefundRequest(orderBean, refundId, fatherOrderId);
//            response = payServiceImpl.orderRefund(orderPayRefundRequest);
//            if (response == null || response.getData() == null || !com.freemud.sdk.api.assortment.order.domain.ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(response.getCode())) {
//                return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "orderRefund_failed");
//            }
            //获取支付返回退款状态
//            state = response.getData().getRefundStatus() == null ? PayRefundStatus.SUCCESS.getCode() : response.getData().getRefundStatus();
            OrderManagerRequest request = new OrderManagerRequest();
            request.setReason(orderRefundVo.getReason());
            PayRefundResponse payRefundResponse = payServiceImpl.payRefundCommon(request, orderBean);
            //获取支付返回退款状态
            state = payRefundResponse.getPayRefundStatus() == null ? PayRefundStatus.SUCCESS.getCode() : payRefundResponse.getPayRefundStatus().getCode();
        }
        CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(),
                partnerId, AfterSalesType.USER_CANCEL, orderRefundVo.getReason(), LogThreadLocal.getTrackingNo(), refundId.toString());
        cancelOrderRequest.setPartnerId(orderBean.getCompanyId());
        if (PayRefundStatus.RUNNING.getCode().intValue() == state) {
            // 退款中
            cancelOrderRequest.setCreateEvent(AfterSalesOrderCreateEventEnum.RETURN_COMPLETE.getCreateEvent());
        } else if (PayRefundStatus.SUCCESS.getCode().intValue() == state) {
            //退款成功
            cancelOrderRequest.setCreateEvent(AfterSalesOrderCreateEventEnum.REFUND_COMPLETE.getCreateEvent());
        }
        cancelOrderRequest.setReqRemark(orderRefundVo.getRemarks());
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderCancel(cancelOrderRequest);
        if (baseOrderResponse == null || baseOrderResponse.getData() == null || !ObjectUtils.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, baseOrderResponse.getErrcode())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "orderRefund_failed");
        }
        return null;
    }


    /**
     * 创建配送
     */
    private boolean createDelivery(OrderBeanV1 orderBean, String trackingNo){
        try {
            // 获取门店信息
            StoreResponse storeResponse = checkOrder.getStoreInfo(orderBean.getCompanyId(), orderBean.getShopId(), trackingNo);
            if (storeResponse == null || storeResponse.getBizVO() == null) {
                AppLogUtil.infoLog(trackingNo, "createDelivery getStoreInfo fail", orderBean.getShopId(), gson.toJson(storeResponse));
                return false;
            }
            OrderExtInfoDto orderExtInfoDto = JSONObject.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class) == null ? new OrderExtInfoDto() : JSONObject.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class);

            GetAuthorizerRequestDto getAuthorizerRequestDto = new GetAuthorizerRequestDto();
            getAuthorizerRequestDto.setPartnerId(orderBean.getCompanyId());
            getAuthorizerRequestDto.setAuthorizerAppid(orderExtInfoDto.getAppid());
            GetTokenResponseDto getTokenResponseDto = ecologyAdminApplicationClient.getAuthorizerAccessToken(getAuthorizerRequestDto);
            if(getTokenResponseDto == null || getTokenResponseDto.getResult() == null || StringUtils.isBlank(getTokenResponseDto.getResult().getAccessToken())) {
                AppLogUtil.infoLog(trackingNo, "createDelivery getToken fail", gson.toJson(getAuthorizerRequestDto), gson.toJson(getTokenResponseDto));
                return false;
            }
            String accessToken = getTokenResponseDto.getResult().getAccessToken();
            CreateDeliveryOrderRequestDto createDeliveryOrderRequestDto = deliveryAdapter.convertToWeixinDeliveryOrderRequestDto(orderBean, storeResponse, accessToken, deliveryNotifyUrl);
            CreateDeliveryOrderResponseDto createDeliveryOrderResponseDto = deliveryService.deliveryOrderAdd(createDeliveryOrderRequestDto, trackingNo);
            /**
             * 创建配送单失败
             */
            if (createDeliveryOrderResponseDto == null || ResponseCodeConstant.RESPONSE_SUCCESS != createDeliveryOrderResponseDto.getCode() || createDeliveryOrderResponseDto.getData() == null) {
                AppLogUtil.infoLog(trackingNo, "createDelivery deliveryOrderAdd fail", gson.toJson(createDeliveryOrderRequestDto), gson.toJson(createDeliveryOrderResponseDto));
                return false;
            }
            String deliveryId = createDeliveryOrderResponseDto.getData().getDeliveryId();
            DeliveryResponseDto<DeliveryInfoDto> dtoDeliveryResponse = deliveryService.deliveryOrderOne(deliveryId, trackingNo);
            /**
             * 运单查询失败
             */
            if (dtoDeliveryResponse == null || ResponseCodeConstant.RESPONSE_SUCCESS != dtoDeliveryResponse.getCode() || dtoDeliveryResponse.getData() == null) {
                AppLogUtil.infoLog(trackingNo, "createDelivery deliveryOrderOne fail", deliveryId, gson.toJson(dtoDeliveryResponse));
                return false;
            }
            DeliveryInfoDto deliveryInfoDto = dtoDeliveryResponse.getData();
            /**
             * 更新配送信息
             */
            UpdateDeliveryInfoByIdRequest updateDeliveryInfoByIdRequest = new UpdateDeliveryInfoByIdRequest();
            updateDeliveryInfoByIdRequest.setDeliveryId(deliveryInfoDto.getDeliveryId());
            updateDeliveryInfoByIdRequest.setOrderId(orderBean.getOid());
            updateDeliveryInfoByIdRequest.setExpressChannelCode(deliveryInfoDto.getCompanyId());
            updateDeliveryInfoByIdRequest.setExpressChannelName(deliveryInfoDto.getRemark());
            updateDeliveryInfoByIdRequest.setExpress(deliveryInfoDto.getCompanyId());
            updateDeliveryInfoByIdRequest.setExpressNo(deliveryInfoDto.getChannelDeliveryId());
            updateDeliveryInfoByIdRequest.setOrderSubState(DeliveryStatus.RIDERSTARTDELIVERY.getCode());
            updateDeliveryInfoByIdRequest.setBizType(BizTypeEnum.MALL.getBizType());
            updateDeliveryInfoByIdRequest.setPartnerId(orderBean.getCompanyId());
            orderCenterSdkService.updateDeliveryInfoById(updateDeliveryInfoByIdRequest);

            /**
             * 更新订单状态配送中
             */
            POSOrderOperationBaseReq directDeliveryReq = new POSOrderOperationBaseReq();
            directDeliveryReq.setOrderCode(orderBean.getOid());
            directDeliveryReq.setPartnerId(orderBean.getCompanyId());
            orderSdkService.directDelivery(directDeliveryReq, trackingNo);
            return true;
        } catch (Exception e) {
            AppLogUtil.infoLog(trackingNo, "createDelivery exception", gson.toJson(orderBean), Throwables.getStackTraceAsString(e));
            return false;
        }
    }

    private BaseResponse checkOrder(QueryOrderByIdResponse response, String partnerId) {
        if (!RESPONSE_SUCCESS_CODE.equals(response.getErrcode()) || response.getData() == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        if (partnerId != null && !partnerId.equals(response.getData().getCompanyId())) {
            return ResponseUtil.error(ResponseResult.ORDER_PARTNER_ID_NOT_MATCTH);
        }
        return null;
    }

    /**
     * 设置商品组信息
     * @param productGroupList
     * @param product
     */
    private void setProductGroupInfo(List<ProductGroup> productGroupList, CreateOrderProductRequest product) {
        if (CollectionUtils.isEmpty(productGroupList)) return;

        List<com.freemud.sdk.api.assortment.order.vo.ProductGroupVo> targetGroupList = Lists.newArrayList();
        for (ProductGroup productGroup : productGroupList) {
            for (GroupDetail groupDetail : productGroup.getGroupDetail()) {
                com.freemud.sdk.api.assortment.order.vo.ProductGroupVo productGroupVo = ProductGroupVo.builder()
                        .groupId(groupDetail.getGroupId()).groupName(productGroup.getName())
                        .thirdGroupId(productGroup.getGroupCode()).build();
                if (!targetGroupList.contains(productGroupVo)) {
                    targetGroupList.add(productGroupVo);
                }
            }
        }
        product.setProductGroupList(targetGroupList);
    }

    private String getThirdPropertyId(List<ProductAttributeGroup> productAttributeGroups, String addInfo) {
        String thirdProductPropertyId = "";
        if(StringUtils.isBlank(addInfo) || CollectionUtils.isEmpty(productAttributeGroups) ){
            return thirdProductPropertyId;
        }
        JSONObject jsonObject = JSONObject.parseObject(addInfo);
        String attributeNames = (String)jsonObject.get("attributeNames");
        List<String> list = new ArrayList<>();
        String[] split = attributeNames.split("/");

        List<AttributeValue> attributeValues = new ArrayList<>();
        for (ProductAttributeGroup attributeGroup : productAttributeGroups){
            attributeValues.addAll(attributeGroup.getAttributeValues());
        }

        for (int i= 0;i<split.length;i++){
            for (AttributeValue attributeValue : attributeValues){
                if(attributeValue.getAttributeValue().equals(split[i])){
                    list.add(attributeValue.getCustomerCode());
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            thirdProductPropertyId = StringUtils.join(list, ",");
        }
        return thirdProductPropertyId;
    }

    @Override
    public BaseResponse saveAfterSalesExpress(EditAfterSalesExpressVo editAfterSalesExpressVo) {
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(editAfterSalesExpressVo.getSessionId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }

        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(editAfterSalesExpressVo.getOid());
        baseQueryOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        OrderBeanV1 orderBean;
        if (queryOrderByIdResponse == null || !RESPONSE_SUCCESS_CODE.equals(queryOrderByIdResponse.getErrcode()) || (orderBean = queryOrderByIdResponse.getData()) == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "订单信息不存在");
        }
        // 检查参数
        BaseResponse response = checkAfterSalesExpress(orderBean, userInfo.getMemberId());
        if (!Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS_STR, response.getCode())) {
            return response;
        }

        // 配送中,完成状态的，用户可填写
        List<Integer> enableRefundExpressCodes = Arrays.asList(NewOrderStatus.DELIVERING.getIndex(), NewOrderStatus.COMPLETE.getIndex());
        if (enableRefundExpressCodes.contains(orderBean.getStatusV2()) && PayStatus.HAVE_PAID.getCode().equals(orderBean.getPayStatus())) {
            EditAfterSalesExpressRequest editAfterSalesExpressRequest = new EditAfterSalesExpressRequest();
            editAfterSalesExpressRequest.setPartnerId(orderBean.getCompanyId());
            editAfterSalesExpressRequest.setStoreId(orderBean.getShopId());
            editAfterSalesExpressRequest.setOrderId(orderBean.getOid());
            editAfterSalesExpressRequest.setOrderClient(Integer.parseInt(orderBean.getOrderClient()));
            editAfterSalesExpressRequest.setExpressNo(editAfterSalesExpressVo.getExpressNo());
            editAfterSalesExpressRequest.setExpressChannelName(editAfterSalesExpressVo.getExpressChannelName());
            editAfterSalesExpressRequest.setAfterSalesCode(orderBean.getAfterSalesOrderResp().getAfterSalesCode());
            editAfterSalesExpressRequest.setOperator(userInfo.getNickName());
            editAfterSalesExpressRequest.setOperationClient(OperationClientEnum.STATE_5.getIndex());
            BaseOrderResponse baseResponseDto = orderCenterSdkService.editAfterSalesExpress(editAfterSalesExpressRequest);

            if (!RESPONSE_SUCCESS_CODE.equals(baseResponseDto.getErrcode())) {
                return ResponseUtil.error(ResponseResult.ORDER_REFUND_EXPRESS_ERROR);
            }
        }
        return ResponseUtil.success();
    }

    private BaseResponse checkAfterSalesExpress(OrderBeanV1 orderBean, String userId) {

        if (!Objects.equals(userId, orderBean.getUserId())) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "不能操作非本人的订单");
        }

        // 必须微商城订单
        if (BizTypeEnum.MALL.getBizType() != orderBean.getBizType()) {
            return ResponseUtil.error(ResponseResult.ORDER_REFUND_EXPRESS_ERROR.getCode(), "非商城订单不可填写");
        }
        // 检查售后单的状态
        AfterSalesOrderResp afterSalesOrderResp = orderBean.getAfterSalesOrderResp();
        if (afterSalesOrderResp == null) {
            return ResponseUtil.error(ResponseResult.ORDER_REFUND_EXPRESS_ERROR.getCode(), "售后单不存在");
        }
        if (Objects.equals(AfterSalesStatus.PENDING.getIndex(), afterSalesOrderResp.getAfterSalesStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER_REFUND_EXPRESS_ERROR.getCode(), "商家正在处理中，请稍后……");
        }
        if (!Objects.equals(AfterSalesStatus.RETURNING.getIndex(), afterSalesOrderResp.getAfterSalesStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER_REFUND_EXPRESS_ERROR.getCode(), "未找到有效的售后单");
        }

        // 是否为 退款退货方式
        CancelOrderRequest.AfterSalesOrderExtInfoReq afterSalesOrderExtInfoVo = getAfterSalesOrderExtInfoVo(afterSalesOrderResp);
        if (Objects.isNull(afterSalesOrderExtInfoVo) || !Objects.equals(RefundModeEnum.REFUND_ALL.getIndex(), afterSalesOrderExtInfoVo.getRefundMode())) {
            return ResponseUtil.error(ResponseResult.ORDER_REFUND_EXPRESS_ERROR.getCode(), "当前退款方式无需填写");
        }

        return ResponseUtil.success();
    }



    private  CancelOrderRequest.AfterSalesOrderExtInfoReq getAfterSalesOrderExtInfoVo(AfterSalesOrderResp afterSalesOrderResp) {
        if (afterSalesOrderResp == null) {
            return null;
        }
        CancelOrderRequest.AfterSalesOrderExtInfoReq afterSalesOrderExtInfoVo = null;
        try {
            afterSalesOrderExtInfoVo = JSON.parseObject(afterSalesOrderResp.getExtInfo(), new com.alibaba.fastjson.TypeReference< CancelOrderRequest.AfterSalesOrderExtInfoReq>() {
            }.getType());
        } catch (Exception e) {
            AppLogUtil.infoLog("解析售后单 extInfo 失败", gson.toJson(afterSalesOrderExtInfoVo), null,e);
        }
        return afterSalesOrderExtInfoVo;
    }

    private String verificationCoupon(String transId, String thirdTradeNo) {
        String orderId = redisCache.getValue(RedisUtil.getPaymentTransIdOrderKey(transId));
        if (StringUtils.isNotBlank(orderId)) {
            transId = orderId;
        }
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = getQueryRelationOrderByIdResponseDto(transId);
        if (queryOrderByIdResponseDto.getData() == null || !Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS, queryOrderByIdResponseDto.getErrcode())) {
            return refundFaileMessage("mallOrderService order query fail" + queryOrderByIdResponseDto);
        }
        OrderBeanV1 orderBean = new OrderBeanV1();
        orderBean.setThirdPartTradeNo(thirdTradeNo);
        if (1 == queryOrderByIdResponseDto.getData().size()) {
            orderBean = queryOrderByIdResponseDto.getData().get(0);
        } else {
            List<OrderBeanV1> orderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(1)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(orderBeans)) {
                orderBean = orderBeans.get(0);
            }
        }
        //核销券
        BaseResponse baseResponse = couponActivityService.verificationCoupon(orderBean, CouponReqType.WRITEOFF);
        return "核销券码返回结果" + baseResponse.getCode() + "," + baseResponse.getMessage();
    }

    /**
     * 退款中回调失败返回信息
     */
    public String refundFaileMessage(String errorMes) {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 102);
        map.put("message", "failed:" + errorMes);
        return gson.toJson(map);
    }

    /**
     * 订单确认收货
     */
    @Override
    public BaseResponse orderReceive(OrderReceiveRequestVO requestVO) {
        BaseResponse result = new BaseResponse();
        AssortmentCustomerInfoVo assortmentCustomerInfoVo = assortmentCustomerInfoManager.getCustomerInfoByObject(requestVO.getSessionId());
        if (assortmentCustomerInfoVo == null || StringUtils.isEmpty(assortmentCustomerInfoVo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }

        try {
            String trackingNo = LogThreadLocal.getTrackingNo();

            BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
            baseQueryOrderRequest.setOrderId(requestVO.getOid());
            baseQueryOrderRequest.setTrackingNo(trackingNo);
            QueryOrderByIdResponse response = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
            // 判断订单信息是否存在
            BaseResponse baseResponse = this.checkOrder(response, requestVO.getPartnerId());
            if (baseResponse != null) {
                return baseResponse;
            }
            OrderBeanV1 orderBean = response.getData();
            //判断订单是否已经完成
            if (NewOrderStatus.COMPLETE.getIndex().equals(orderBean.getStatusV2())) {
                return ResponseUtil.error(ResponseResult.ORDER_REPEAT_DO_COMPLETE);
            }
            //已取消的订单不能操作
            if (NewOrderStatus.CLOSED.getIndex().equals(orderBean.getStatusV2())) {
                return ResponseUtil.error(ResponseResult.ORDER_HAS_CANCELED);
            }
            //非商城订单不允许操作
            if (BizTypeEnum.MALL.getBizType() != orderBean.getBizType()) {
                return ResponseUtil.error(ResponseResult.ORDER_MALL_NOT_MATCH);
            }

            /**
             * 修改配送状态
             */
            OrderChangeStateReq request = new OrderChangeStateReq();
            request.setOrderCode(baseQueryOrderRequest.getOrderId());
            request.setOrderState(NewOrderStatus.COMPLETE.getIndex());
            request.setOperator(assortmentCustomerInfoVo.getNickName());
            request.setPartnerId(orderBean.getCompanyId());
            request.setTaskType(Arrays.asList((byte) 5));
            request.setRemark("已完成");
            orderSdkService.updateOrderState(request, baseQueryOrderRequest.getTrackingNo());
            orderSdkService.completeBookingTask(request, baseQueryOrderRequest.getTrackingNo());
            return ResponseUtil.success();
        }catch (Exception e){
            result.setCode(ResponseResult.ORDER_RECEIVE_ERR.getCode());
            result.setMessage(ResponseResult.ORDER_RECEIVE_ERR.getMessage());
        }
        return result;
    }

}
