package cn.freemud.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 补偿状态
 */
@Getter
public enum OrderResourcePushState {

    DEFAULT((byte) 0, "失败"),
    SUCCESS((byte) 1, "补偿成功"),
    ;

    private final Byte index;
    private final String name;

    OrderResourcePushState(Byte index, String name) {
        this.index = index;
        this.name = name;
    }


    private static class EnumCacheHolder {
        private static final Map<Byte, OrderResourcePushState> CACHE;

        static {
            CACHE = Arrays.stream(OrderResourcePushState.values()).collect(Collectors.toMap(OrderResourcePushState::getIndex, v -> v));
        }
    }

    public static OrderResourcePushState getByIndex(Byte index) {
        return EnumCacheHolder.CACHE.get(index);
    }

    public static OrderResourcePushState getByIndexOrDefault(Byte index, OrderResourcePushState defaultEnum) {
        OrderResourcePushState en = EnumCacheHolder.CACHE.get(index);
        return en == null ? defaultEnum : en;
    }
}
