package cn.freemud.service.impl.mcoffee.entity;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2021-01-26 09:48:38
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Getter
@Setter
public class MCoffeeBatchAddGoodsRequestVo {
    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;
    /**
     * 商户Id
     */
    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    /**
     * 微信appId
     */
    @NotEmpty(message = "appId不能为空")
    private String appId;
    /**
     * 门店Id
     * 商城没有门店id，如果需要门店id必传在业务中进行校验
     */
    private String shopId;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    private String channelType;
    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private String menuType ;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;
    /**
     * 商品信息
     */
    private List<BatchGoodsInfoVo> goodsInfos;
}
