package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
public class DiscountActivityDto {

    private String partnerId;

    private String storeId;

    private String wxAppId;

    private String activityId;

    private List<DiscountMessage> products;

    @Data
    @NoArgsConstructor
    public static class DiscountMessage {

        private String spuId;
        private String skuId;

        private String productName;
        /**
         * 活动id
         */
        private Long activityId;
        /**
         * 每单限购数量
         */
        private int limtBuyCountEachOrder;
        /**
         * 活动商品总库存
         */
        private long  inventoryNumber;
        /**
         * 活动商品剩余库存
         */
        private Integer  remainStock;
        /**
         *  折扣后的价格
         */
        private long  discountPrice;
        /**
         *  原价
         */
        private long  originalPrice;
    }

}
