/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单状态
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum CouponFlag {

    NO(0, "不查询"),
    YES(1, "查询用户优惠券");

    private Integer code;
    private String desc;

    CouponFlag(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponFlag getByCode(Integer code) {
        for (CouponFlag payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
