package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.ProductStockBO;
import cn.freemud.demo.entities.ValiadShopProductBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import cn.freemud.entities.dto.RequiredProductRequest;
import cn.freemud.utils.BeanUtil;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.application.sdk.api.productcenter.response.valid.ValiadShopProductResponse;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;

@Component
public class ProductDTO2BOAdapter {


    @Resource
    private MapperFacade mapperFacade;

    public ProductBO convert2ProductBO(ProductBeanDTO productBeanDTO, Map<String, String> idMap) {

        ProductBO productBO = BeanUtil.convertBean(productBeanDTO, ProductBO::new);
        productBO.setSpuId(productBeanDTO.getPid());
        productBO.setSkuId(idMap.get(productBeanDTO.getPid()));
        return productBO;
    }

    public ProductStockBO convert2ProductStockBO(GetProductStockResponseDto.DataBean ProductStockDTO) {

        ProductStockBO productStockBO = BeanUtil.convertBean(ProductStockDTO, ProductStockBO::new);
        return productStockBO;
    }


    public ValiadShopProductBO convert2ProductStockBO(ValiadShopProductResponse valiadShopProductResponse) {

        ValiadShopProductBO bo = BeanUtil.convertBean(valiadShopProductResponse, ValiadShopProductBO::new);
        return bo;
    }

}
