package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.CouponCodeResponseDto;
import cn.freemud.entities.dto.CouponCodeVerificationMCCafeDto;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

@FeignClient(name = "COUPONMCCafe",url="http://coupon-api-gateway-koderover-dev-coupon.api-ingress.sandload.cn")
public interface CouponOfflineMCCafeClient {

    @PostMapping("/mccafe/redeem")
    CouponRedeemResponse redeem(CouponCodeVerificationMCCafeDto couponCodeVerificationMCCafeDto);

    @PostMapping("/mccafe/cancelRedeem")
    CouponRedeemResponse cancelRedeem(CouponCodeVerificationMCCafeDto couponCodeVerificationMCCafeDto);

    @PostMapping("/mccafe/query")
    CouponRedeemResponse query(CouponCodeVerificationMCCafeDto couponCodeVerificationMCCafeDto);

    @PostMapping("/mccafe/lock")
    CouponRedeemResponse lock(CouponCodeVerificationMCCafeDto couponCodeVerificationMCCafeDto);

    @PostMapping("/mccafe/unlock")
    CouponRedeemResponse unlock(CouponCodeVerificationMCCafeDto couponCodeVerificationMCCafeDto);
}
