package cn.freemud.management.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.service.OrderDeliveryService;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 创建配送单
 */
@Slf4j
@RequestMapping("/order")
@RestController
@Validated
public class DeliveryOrderController {

    @Autowired
    private OrderDeliveryService orderDeliveryService;

    @ApiAnnotation(logMessage = "创建配送单")
    @ApiOperation(value = "创建配送单", notes = "创建配送单", produces = "application/json")
    @GetMapping("/delivery/create")
    public BaseResponse deliveryCreate(@RequestParam("orderCode") String orderCode
            , @RequestParam(value = "operator", required = false) String operator) {
        return orderDeliveryService.createDelivery(orderCode, operator);
    }
}
