package cn.freemud.management.entities.dto.response.pay;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Objects;

/**
 * @author Clover.z
 * @version 1.0.0
 * @since 1.0.0
 */
@NoArgsConstructor
@Data
public class AgentPayRefundResp {
    private Integer code;
    private DataDTO data;
    private String msg;

    @NoArgsConstructor
    @Data
    public static class DataDTO {
        private String fmTradeNo;
        private String endTransTradeNo;
        private String platformTradeNo;
        private String fmRefundNo;
        private String refundEndTransTradeNo;
        private Integer refundAmount;
        private Integer settleRefundAmount;
        private Integer mcouponAmount;
        private Integer pcouponAmount;
        private Integer totalAmount;
        private String refundCurrency;
        private String refundDesc;
        private String refundTime;
        private String transId;
        private String ebcode;
    }

    public boolean isOk() {
        return Objects.equals(code, 200);
    }
}
