package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.GetActivityBO;
import cn.freemud.demo.entities.GetCalculationDiscountBO;
import cn.freemud.demo.entities.GetProductStock;
import cn.freemud.demo.entities.QueryActivityByTypeDTO;
import cn.freemud.demo.entities.ValiadShopProductBO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class PromotionBO2DTOAdapter {


    @Resource
    private MapperFacade mapperFacade;


    public CalculationSharingDiscountRequestDto convert2CalculationSharingDiscountRequestDto(GetCalculationDiscountBO getProductStock) {

        CalculationSharingDiscountRequestDto dto = BeanUtil.convertBean(getProductStock, CalculationSharingDiscountRequestDto::new);
        return dto;
    }

    public QueryActivityByTypeDTO convert2QueryActivityByTypeDTO(GetActivityBO getActivityBO) {

        // QueryActivityByTypeDTO dto = mapperFacade.map(getActivityBO, QueryActivityByTypeDTO.class);

        QueryActivityByTypeDTO dto = BeanUtil.convertBean(getActivityBO, QueryActivityByTypeDTO::new);
        return dto;
    }

}
