package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.ValidateShopProductRequestBO;
import cn.freemud.demo.entities.GetProductStock;
import cn.freemud.demo.entities.GetRequiredProductListBO;
import cn.freemud.demo.entities.PaidRuleResponseBO;
import cn.freemud.demo.entities.ProductStockBO;
import cn.freemud.entities.dto.GetProductStockRequestDto;
import cn.freemud.entities.dto.GetProductStockResponseDto;
import cn.freemud.entities.dto.RequiredProductRequest;
import cn.freemud.utils.BeanUtil;
import com.freemud.application.sdk.api.productcenter.request.product.valid.ValidateShopProductRequest;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ProductBO2DTOAdapter {

    @Resource
    private MapperFacade mapperFacade;


    public GetProductStockRequestDto convert2GetProductStockDto(GetProductStock getProductStock) {
        GetProductStockRequestDto getProductStockRequestDto = new GetProductStockRequestDto();
        getProductStockRequestDto.setChannel(getProductStock.getChannel());
        getProductStockRequestDto.setPartnerId(getProductStock.getPartnerId());
        getProductStockRequestDto.setProductIds(getProductStock.getProductIds());
        getProductStockRequestDto.setStoreId(getProductStock.getStoreId());

        return getProductStockRequestDto;
    }

    public ValidateShopProductRequest convert2ValidateShopProductRequest(ValidateShopProductRequestBO validateShopProductRequestBO) {

        ValidateShopProductRequest validateShopProductRequest = BeanUtil.convertBean(validateShopProductRequestBO, ValidateShopProductRequest::new);

        return validateShopProductRequest;
    }

    public RequiredProductRequest convert2RequiredProductRequest(GetRequiredProductListBO getRequiredProductListBO) {

        RequiredProductRequest requiredProductRequest = BeanUtil.convertBean(getRequiredProductListBO, RequiredProductRequest::new);

        return requiredProductRequest;
    }

}
