package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.PaidRuleResponseBO;
import cn.freemud.demo.entities.ReceiveAddressBO;
import cn.freemud.demo.entities.StoreInfoBO;
import cn.freemud.demo.entities.UserScoreUserDetailBO;
import cn.freemud.entities.dto.GetPaidRuleRequestDto;
import cn.freemud.entities.dto.GetPaidRuleResponseDto;
import cn.freemud.entities.dto.user.GetUserScoreUserDetailResponse;
import cn.freemud.utils.BeanUtil;
import com.freemud.application.sdk.api.membercenter.response.QueryReceiveAddressResponse;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class CustomerDTO2BOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public ReceiveAddressBO convert2StoreInfoBO(QueryReceiveAddressResponse dto) {

        ReceiveAddressBO bo = BeanUtil.convertBean(dto, ReceiveAddressBO::new);

        return bo;
    }

    public UserScoreUserDetailBO convert2UserScoreUserDetailBO(GetUserScoreUserDetailResponse dto) {

        UserScoreUserDetailBO bo = BeanUtil.convertBean(dto, UserScoreUserDetailBO::new);
        return bo;
    }

    public PaidRuleResponseBO convert2PaidRuleResponseBO(GetPaidRuleResponseDto dto) {

        PaidRuleResponseBO bo = BeanUtil.convertBean(dto, PaidRuleResponseBO::new);
        return bo;
    }

}
