package cn.freemud.manager;

import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.adapter.OrderCenterSdkAdapter;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.QueryByCodeResponse;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderManager {

    @Autowired
    private OrderSdkService orderSdkService;

    @Autowired
    private OrderCenterSdkAdapter orderCenterSdkAdapter;

    public QueryOrderByIdResponse queryOrderById(BaseQueryOrderRequest request){
        QueryOrderByIdResponse queryOrderByIdResponse = new QueryOrderByIdResponse();
        String trackingNo =  LogThreadLocal.getTrackingNo();
        QueryByCodeResponse orderInfo = orderSdkService.getOrderInfo(request.getOrderClient(), request.getOrderId(),
                request.getThirdOrderCode(), request.getWithOperationHistory(), trackingNo);
        if(orderInfo != null){
            queryOrderByIdResponse.setErrcode(Integer.parseInt(orderInfo.getCode()));
            queryOrderByIdResponse.setErrmsg(orderInfo.getMessage());
        }
        if(orderInfo != null && orderInfo.getResult() != null && StringUtils.isNotEmpty(orderInfo.getResult().getOrderCode())){
            OrderBeanV1 orderBeanV1 = orderCenterSdkAdapter.convent2NEWOrderInfo(orderInfo.getResult());
            queryOrderByIdResponse.setData(orderBeanV1);
        }
        return queryOrderByIdResponse;
    }

}
