package cn.freemud.demo.manager.product;

import cn.freemud.demo.adapter.manager.ProductDTO2BOAdapter;
import cn.freemud.demo.entities.bo.goods.GetProductBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.service.impl.AssortmentSdkService;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

@Service("KgdProductService")
public class KgdProductServiceImpl implements ProductService {


    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private ProductDTO2BOAdapter productDTO2BOAdapter;

    @Override
    public ProductBO getProductInfo(GetProductBO getProductBO) {
        // 获取添加商品的详细信息
        List< ProductBeanDTO> productBeanListSpuClass = assortmentSdkService.getProductsInfoSdk(getProductBO.getPartnerId(),
                        getProductBO.getStoreId(), Collections.singletonList(getProductBO.getSkuid()), getProductBO.getMenuType(), null);
        ProductBeanDTO productBeanDTO = productBeanListSpuClass.get(0);

        ProductBO platformProductBO = productDTO2BOAdapter.convert2ProductBO(productBeanDTO);

        return platformProductBO;
    }


}
