package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.AddGoodsShoppingCartBO;
import cn.freemud.demo.entities.dto.goods.add.BaseAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.MCoffeeAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.PlatformAddGoodsVO;
import cn.freemud.demo.enums.BizTypeEnum;
import org.springframework.stereotype.Component;

@Component
public class AddGoodsVOAdapter {

    public BaseAddGoodsVO convert2AddGoodsVO(String bizType, AddGoodsShoppingCartBO baseAddGoodsBO) {
        BaseAddGoodsVO baseAddGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }


    private PlatformAddGoodsVO createPlatformVO(AddGoodsShoppingCartBO baseAddGoodsBO) {
        PlatformAddGoodsVO platformAddGoodsVO = new PlatformAddGoodsVO();
        return platformAddGoodsVO;
    }

    private MCoffeeAddGoodsVO createMCoffeeVO(AddGoodsShoppingCartBO baseAddGoodsBO) {
        MCoffeeAddGoodsVO mCoffeeAddGoodsVO = new MCoffeeAddGoodsVO();
        return mCoffeeAddGoodsVO;
    }

}
