package cn.freemud.service;

import ch.qos.logback.classic.Level;
import cn.freemud.amp.EnumEmailAlert;
import cn.freemud.amp.util.BodyConvertUtil;
import cn.freemud.constant.ServiceConstants;
import cn.freemud.resposne.SynchronizationOrderResponse;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.membercenter.request.SendScoreRequest;
import com.freemud.application.sdk.api.membercenter.service.MemberPropertyService;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.service.EmailAlertService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: $ 经验发放处理类
 * @author: aiqi.gong
 * @date: 2019/3/21 18:37
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service("sendScoreHandleServiceImpl")
@Slf4j
public class SendScoreHandleServiceImpl implements SynchronizedScoreAndExpService {

    @Autowired
    private MemberPropertyService memberPropertyService;

    @Autowired
    private EmailAlertService emailAlertService;

    /**
     * 积分发送
     *
     * @param uuid
     * @param orderBody
     * @return 处理结果
     */
    @Override
    public SynchronizationOrderResponse synchronizationOrder(String uuid, OrderInfoReqs orderBody) {
        SynchronizationOrderResponse synchronizationOrderResponse = new SynchronizationOrderResponse(Boolean.FALSE, null);
        SendScoreRequest sendScoreRequest = sendScoreBodyConvertToSendScoreRequest(orderBody);
        BaseResponse baseResponse = memberPropertyService.sendScore(sendScoreRequest, uuid);
        if (ServiceConstants.SUCCESS_STR.equalsIgnoreCase(baseResponse.getCode())) {
            synchronizationOrderResponse.setResult(Boolean.TRUE);
        }
        else if ("1207".equalsIgnoreCase(baseResponse.getCode())) {
            //如果商户没有配置积分规则，发邮件告知
         /*   emailAlertService.sendEmailAlert(EnumEmailAlert.Description.NoScoreRule.getDescription(),
                    "request:" + JSON.toJSONString(sendScoreRequest)
                            + "response:" + JSON.toJSONString(baseResponse)
            );*/
        }

        return synchronizationOrderResponse;
    }

    private SendScoreRequest sendScoreBodyConvertToSendScoreRequest(OrderInfoReqs orderBody) {
        SendScoreRequest sendScoreRequest = new SendScoreRequest();
        if (null != orderBody) {
            sendScoreRequest.setPartnerId(orderBody.getPartnerId());
            sendScoreRequest.setMemberId(orderBody.getUserId());
            sendScoreRequest.setAmount(orderBody.getSettlementAmount() == null ? 0 : orderBody.getSettlementAmount().intValue());
            sendScoreRequest.setOperationType(ServiceConstants.OPERATION_TYPE_1);//消费送积分
            sendScoreRequest.setOrderId(orderBody.getOrderCode());
            sendScoreRequest.setIdempotencyBussinessId(orderBody.getOrderCode());
            sendScoreRequest.setIdempotencyBussinessType(ServiceConstants.IDEMPOTENCY_BUSSINESS_TYPE_6);
            sendScoreRequest.setOrgType(3);
            sendScoreRequest.setOrgCode(orderBody.getStoreId());
        }
        return sendScoreRequest;
    }
}
