package cn.freemud.fuyou.service.processor;

import cn.freemud.base.util.DateUtil;
import cn.freemud.enums.PayChannelEnum;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.service.PaymentService;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.OrderSettlementType;
import com.freemud.application.sdk.api.ordercenter.enums.ResponseResultEnum;
import com.freemud.application.sdk.api.ordercenter.request.OrderSettlementReq;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import com.freemud.application.sdk.api.paymentcenter.client.request.CodePayRequest;
import com.freemud.application.sdk.api.paymentcenter.client.response.CodePayResponse;
import com.freemud.application.sdk.api.paymentcenter.client.service.PaymentNewService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Component;

import java.util.Date;


@Component
@Slf4j
public class AliPayEventProcessor extends AbstractProcessor {

//10211        扫呗支付
//10001        支付宝
//10004        微信条码
//10015        QQ钱包
//10016        翼支付
//10008        百度钱包
//10014        德仕钱包
//10020        拉卡拉
//10016        易付宝
//10018        付费通
//10017        京东
//10024        会员
//10025        工商银行
//10026        百度糯米支付
//10027        建设银行
//10028        刷卡支付
//10030        付呗
//10031        银联
//10001        境外支付宝
//10035        和包
//10037        通莞金服
//10039        大众支付
//10007        微信小程序
//10045        香港微信
//10046        费芮支付
//10044        支付宝充值
//10040        微信充值
//10089        全家会员付
//10092        支付宝刷脸付
//10091        微众线上支付
//10093        银商线上支付
//10094        微信扫码支付
//10095        支付宝扫码支付
//10096        扫码支付
//10098        银商
//10099        易百微信小程序
//10090        纳客宝积分支付
//10047        微信H5支付
//10200        预付费卡
//10102        会员线上付
//10100        招行一招过
//10042        威富通微信
//10023        万集卡
//10022        购开心
//10103        微众余额卡
//10202        石基小程序支付
//10210        微众签约支付
//10203        微信扫脸支付
//10102        svc储值卡
//10204        优赋小程序支付
//10212        微信APP支付
//10213        易宝支付
//10214        赢商通支付
//10215        米雅支付
//10216        扫呗公众号支付
//10217        商盟支付
//10300        扫呗支付宝
private final PaymentNewService paymentNewService;

    protected AliPayEventProcessor(OrderSdkService orderSdkService, PaymentService paymentService, PaymentNewService paymentNewService) {
        super(orderSdkService, paymentService);
        this.paymentNewService = paymentNewService;
    }

    @Override
    BaseResponse doProcess(DiscountRequest request) {
        BaseResponse baseResponse =new BaseResponse();
        baseResponse.setCode(ResponseResultEnum.SUCCESS.getCode());
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());

        CodePayRequest codePayRequest =new CodePayRequest();
        codePayRequest.setCode(request.getCode());
        codePayRequest.setBody(orderInfoReqs.getStoreName());
        codePayRequest.setBusinessDate(DateUtil.convert2String(new Date(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        codePayRequest.setStationId("1");
        codePayRequest.setOperatorId("1");
        //codePayRequest.setClientCode(10095);
        //codePayRequest.setCode("10102");
        codePayRequest.setAmount(request.getPayAmount());
        codePayRequest.setPartnerId(orderInfoReqs.getPartnerId());
        codePayRequest.setStoreId(orderInfoReqs.getStoreId());
        codePayRequest.setFrontTransId(orderInfoReqs.getOrderCode());
        codePayRequest.setVer("2");
       // codePayRequest.setClientCode(10095L);
        codePayRequest.setTransId(orderInfoReqs.getOrderCode());
        codePayRequest.setProducts(convertPayProduct(request.getOrderItemList()));
        com.freemud.application.sdk.api.base.BaseResponse<CodePayResponse> codePayResponseBaseResponse = paymentNewService.codePay(codePayRequest, LogThreadLocal.getTrackingNo());
        log.info("aliPay.paymentFeignClient.codePay,request:{},response:{}", JSON.toJSONString(codePayRequest),JSON.toJSONString(codePayResponseBaseResponse));
        if(ObjectUtils.notEqual(ResponseResultEnum.SUCCESS.getCode(),codePayResponseBaseResponse.getCode()) ||
                ObjectUtils.notEqual(ResponseResultEnum.SUCCESS.getCode(),codePayResponseBaseResponse.getData().getCode()) ||
                ObjectUtils.notEqual(ResponseResultEnum.SUCCESS.getCode(),codePayResponseBaseResponse.getData().getData().getResultCode())
        ){
            baseResponse.setCode(codePayResponseBaseResponse.getCode());
            baseResponse.setMessage(codePayResponseBaseResponse.getMessage());
            return baseResponse;
        }
        request.setFmId(codePayResponseBaseResponse.getData().getData().getFmId());
        return baseResponse;
    }



    @Override
    OrderSettlementReq getOrderSettlement(DiscountRequest request) {
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());
        return buildOrderSettlement("支付宝支付", OrderSettlementType.ALIPAY, true, orderInfoReqs, request);

    }

    @Override
    public Integer getEvent() {
        return PayChannelEnum.ALIPAY.getCode();
    }
}
