package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.openplatform.QueryInvoiceConfigRequest;
import cn.freemud.entities.dto.order.OrderInvoiceResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/4/27 下午2:03
 * @description :
 */
@FeignClient(name = "MICRO-OPENPLATFORM")
@RequestMapping(consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public interface MicroOpenplatformClient {

    /**
     * 获取需要 上报腾讯有数的 商户号
     *
     * @return
     */
    @LogIgnoreFeign(logMessage="orderInvoiceQueryByPartnerId")
    @PostMapping("/order/invoice/config/queryByPartnerId")
    BaseResponse<OrderInvoiceResponse> QueryInvoiceConfigByPartnerId(@RequestBody QueryInvoiceConfigRequest request);

}
