/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMenuResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/10 16:23
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import cn.freemud.entities.dto.product.info.ProductBean;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class GetMenuResponseDto {


    private DataBean data;
    private Integer errcode;
    private String errmsg;

    @NoArgsConstructor
    @Data
    public static class DataBean {
        /**
         * 渠道 beiguo saas
         */
        private String channel;
        /**
         * 菜单 menu ID
         */
        private String mid;
        /**
         * 商品适用渠道  北国超市
         */
        private String name;
        /**
         * 商品节点
         */
        private RootNodeBean rootNode;

        @NoArgsConstructor
        @Data
        public static class RootNodeBean {
            /**
             * 子节点数量
             */
            private int childrenNum;
            /**
             * 是否有子节点
             */
            private int hasChild;
            private int level;
            /**
             * 菜单Id
             */
            private String menuId;
            private String name;
            private String nid;
            private Object product;
            private String productId;
            private String remark;
            private int sequence;
            private String type;
            private List<ChildrenBeanFirst> children;
            private List<?> labelNameList;

            @NoArgsConstructor
            @Data
            public static class ChildrenBeanFirst {
                private int childrenNum;
                private int hasChild;
                private int level;
                private String menuId;
                /**
                 * 分类名称
                 */
                private String name;
                /**
                 * 节点名称
                 */
                private String nid;
                private Object product;
                private String productId;
                private String remark;
                private int sequence;
                private String type;
                private List<ChildrenBeanSecond> children;
                private List<?> labelNameList;

                @NoArgsConstructor
                @Data
                public static class ChildrenBeanSecond {

                    private int childrenNum;
                    private int hasChild;
                    private int level;
                    private String menuId;
                    private String name;
                    private String nid;
                    private ProductBean product;
                    private String productId;
                    private String remark;
                    private int sequence;
                    private String type;
                    private List<?> children;
                    private List<?> labelNameList;
                }
            }
        }
    }
}
