package cn.freemud.entities.dto.pay.svc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/5/10 18:00
 * @description :
 */
@Data
public class CardApplyRes {
    @ApiModelProperty("卡档案Id")
    private Integer id;

    @ApiModelProperty(value = "卡档案名")
    private String name;

    @ApiModelProperty(value = "卡面信息，卡面配图链接")
    private String mark;

    @ApiModelProperty(value = "规则说明")
    private String ruleRemark;

    @ApiModelProperty(value = "卡档案编号")
    private String thirdNo;

    @ApiModelProperty(value = "创建人")
    private String createUser;

    @ApiModelProperty(value = "最后操作人")
    private String updateUser;

    @ApiModelProperty(value = "创建时间str")
    private String createDate;

    @ApiModelProperty(value = "最后更新时间Str")
    private String updateDate;

    @ApiModelProperty(value = "在售状态，默认上线，1上架，0下架")
    private Integer onShelf;

    @ApiModelProperty(value = "启充状态，默认启用，1-启用，0-停用")
    private Integer enableRecharge;

    @ApiModelProperty(value = "推荐状态, 默认未设置，1-推荐，0-未设置")
    private Integer enablePromote;

//    /**
//     * 门店列表
//     */
//    @ApiModelProperty("门店列表")
//    private List<CardApplyStoreVo> stores;
//
//    /**
//     * 渠道分组列表
//     */
//    @ApiModelProperty("渠道分组列表")
//    private List<CardApplyOrgVo> orgs;
//
//    /**
//     * 渠道分组列表
//     */
//    @ApiModelProperty("推荐地区列表")
//    private List<CardApplyRegionRecommendVo> regions;

    @ApiModelProperty(value = "适用门店：1-部分门店 2-渠道分组 3-全部门店")
    private Byte whiteChoiceMode;

    @ApiModelProperty(value = "不适用门店：1-部分门店 2-渠道分组 3-无")
    private Byte blackChoiceMode;

    @ApiModelProperty(value = "推荐模式：1-全部 2-部分渠道")
    private Byte recommendMode;

    @ApiModelProperty(value = "不推荐模式：1-全部 2-部分渠道")
    private Byte notRecommendMode;

    @ApiModelProperty(value = "适用范围，全门店通用或仅限上海地区门店使用等")
    private String applyScope;

    @ApiModelProperty(value = "0:线上卡档案, 1:线下卡档案")
    private Integer cardApplyType;

    @ApiModelProperty(value = "储值卡活动标签图片地址")
    private String promotionLabelImg;

    @ApiModelProperty(value = "储值卡活动标签宣传语")
    private String promotionLabelDesc;

    /**
     */
    @ApiModelProperty("是否开启线下充值（设为仅线下充值后，用户只能到门店充值，在小程序无法充值） 1-是 0-否，默认为0")
    private Byte enableOfflineRecharge;

    @ApiModelProperty("有效期")
    private Integer effectDuration;

    /**
     * 复用card表中的cardType字段
     */
    @ApiModelProperty("卡类型：0礼品卡，3储值卡")
    private Integer applyType;

    @ApiModelProperty("有效期类型 0|永久有效 1|固定时长 2|固定日期")
    private Integer effectType;

    @ApiModelProperty("固定时长有效期时间单位 6|年 5|月 4|日 3|时 2|分 1|秒")
    private Integer timeUnit;

    @ApiModelProperty(value = "同步到哪个三方：1：银商，null默认不同步")
    private Integer syncThirdParty;

    @ApiModelProperty("渠道和门店黑白名单校验,true通过，false未通过")
    private Boolean whiteBlackVerify;

    @ApiModelProperty(value = "是否设置获取成长值 1-是 0-否")
    private Integer enableGrowth;

    @ApiModelProperty(value = "是否设置获取积分配置 1-是 0-否")
    private Integer enableScore;

    @ApiModelProperty(value = "卡档案子类型 1:普通, 2:抖音")
    private Integer cardApplySubType;

    @ApiModelProperty(value = "是否开启转赠 1-开启 0-关闭")
    private Integer enableTransfer;

    @ApiModelProperty(value = "单人当天冲值次数限制")
    private Integer dayChargeTimes;

    @ApiModelProperty(value = "单人最大冲值次数限制")
    private Integer maxChargeTimes;

    @ApiModelProperty(value = "是否与营销活动共享 1-是 0-否")
    private Integer enableSharing;
}
