/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderPayResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/25 17:10
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto.pay;

import com.freemud.application.sdk.api.ordercenter.enums.PayChannelType;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderPayItemResp;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.ArrayList;
import java.util.List;

//sdk 类迁移

@NoArgsConstructor
@Data
@ToString
public class OrderPayResponse {
    /**
     * pay_transId : 84617583993553153103
     * pay_id : 微信小程序支付
     * pay_ebcode : 10007
     * fmId : ZHL1407O1555247503
     * pay_order : {"appid":"wx3ab08e23966343fe","package":"prepay_id=wx25143630149413bcd9fbad100070370076","nonce_str":"-610630281","sign":"D320B2B74D858EBE16841F43AE70E757","timestamp":"1527230190","signType":"MD5"}
     * statusCode : 100
     */

    /**
     * 支付交易序号
     */
    private String payTransId;

    /**
     * 支付方式描述
     */
    private String payId;

    private String payEbcode;

    private String msg;

    /**
     * 非码交易ID
     */
    private String fmId;

    private PayOrderBean payOrder;

    private Integer statusCode;

    private String openId;

    private String partnerId;

    private String wxAppid;

    private String orderId;
//    private String payMode;

    private PayChannelType payChannelType;

    private List<OrderPayItemResp> payItem = new ArrayList<>();

    // 回调地址
    private String payNotifyUrl;
    //商户id
    private String sellerId;
    // 支付类型：机场支付=20099
    private String ebCode;

    /**
     * 抖音支付的返回的为orderId 映射为我们thirdOrderId
     */
    private String thirdOrderId;

    /**
     * 抖音支付的orderToken 映射为我们thirdOrderToken
     */
    private String thirdOrderToken;

    //商户订单号
    private String endTransId;

    /**
     * 修复随行付返回的endTransId无法满足一元捐插件，支付接口新增的落单号字段（对应微信商户单号）
     */
    private String channelPayId;

    /**
     * 储值卡流水明细 储值卡消费结果通知储值交易服务
     */
    private List<SvcPayItem> svcPayItems;


    @NoArgsConstructor
    @Data
    public static class PayOrderBean {
        /**
         * appid : wx3ab08e23966343fe
         * package : prepay_id=wx25143630149413bcd9fbad100070370076
         * nonce_str : -610630281
         * sign : D320B2B74D858EBE16841F43AE70E757
         * timestamp : 1527230190
         * signType : MD5
         */

        private String appid;

        private String packageX;

        private String nonceStr;

        /**
         * 签名
         */
        private String sign;

        private String timestamp;

        /**
         * 签名方式
         */
        private String signType;

        private String aliPayOrder;


    }
}
