package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.OldOrderStatus;
import com.freemud.sdk.api.assortment.order.enums.QueryOrderType;
import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: AssortmentGroupCreateOrderRequest
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/9/320:05
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class AssortmentGroupUpdateOrderRequest extends AssortmentGroupCreateOrderRequest {

    //支付渠道
    private String payChannel;

    //支付渠道名称
    private String payChannelName;

    //当前支付请求号
    private String payRequestNo;

    //支付时间
    private String payTime;

    //支付类型 1:线上支付 2:线下支付
    private Integer payType;

    //pos编号
    private String posCode;

    //用户在界面上看到的支付金额
    private Long settlementAmount;

    //订单编号
    private String orderCode;

    //实际支付现金金额，扣除支付自生优惠，单位分
    private Long actualPayAmount;

    //订单原始金额，单位分
    private Long originalAmount;

    /**
     * 其他结算列表
     */
    private List<CreateOrderAccountRequest> accounts;

}
