package cn.freemud.management.service.adapter;

import cn.freemud.management.enums.OrderSource;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.impl.McCafeMangerServiceImpl;
import cn.freemud.management.service.impl.SaasOrderMangerServiceImpl;
import cn.freemud.management.service.impl.WaimaiOrderMangerServiceImpl;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 根据渠道获取渠道操作实体类
 */
@Service
public class OrderBeanFactory {

    @Value("${mccafe.partner.id}")
    private String macCafePartnerId;

    @Value("#{'${o2o.orderClient}'.split(',')}")
    private List<String> o2oOrderClients;

    @Autowired
    private ApplicationContext applicationContext;

    public OrderManagerService getOrderManagerService(QueryOrdersResponse.DataBean.OrderBean orderBean){
//        String source = orderBean.getSource();
        String orderClient = orderBean.getOrderClient();
        String companyId = orderBean.getCompanyId();
        if (macCafePartnerId.equals(companyId)){
            return  applicationContext.getBean(McCafeMangerServiceImpl.class);
        }
//        if (OrderSource.BDWM.getSource().equals(source) || OrderSource.JDWM.getSource().equals(source)
//                || OrderSource.MTWM.getSource().equals(source) || OrderSource.ELEME.getSource().equals(source)
//                || OrderSource.FMWD.getSource().equals(source) || OrderSource.EBAI.getSource().equals(source)
//                || OrderSource.KOUBEI.getSource().equals(source) || OrderSource.DPZHCT.getSource().equals(source)){
//            return applicationContext.getBean(WaimaiOrderMangerServiceImpl.class);
//        }
        if (o2oOrderClients.contains(orderClient)){
            return applicationContext.getBean(WaimaiOrderMangerServiceImpl.class);
        }
        return applicationContext.getBean(SaasOrderMangerServiceImpl.class);
    }
}
