package cn.freemud.service.adapter;


import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.utils.AppLogUtil;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Objects;

/**
 * 订单校验
 */
public class OrderCheckAdapter {

    static ArrayList<OrderCheck> orderCheckList = Lists.newArrayList(new ToStoreCheck(), new TakeOutOrderCheck());

    /***
     * 校验预约单门店数据
     * @param vo
     * @param storeResponse
     * @throws ServiceException 抛出异常校验异常数据
     */
    public static void check(CreateOrderVo vo, StoreResponse storeResponse) throws ServiceException {
        //非预约单的过滤
        if (Objects.isNull(vo.getOrderType()) ||
                (!Objects.equals(vo.getTakeMealFlag(), "1"))) {
            return;
        }
        StoreResponse.Configuration configuration = storeResponse.getBizVO().getStoreConfig();
        if(Objects.isNull(configuration)){
            //针对老数据没有配置 预约单默认支持，直接返回不校验
            AppLogUtil.infoLog("商户:{} shopId:{},没有配置预约单",vo.getPartnerId(),vo.getShopId());
            return;
        }
        AppLogUtil.debugLotsParams("门店：{}，外卖预约单状态：{}，自提预约单状态:{}", vo.getShopId(), configuration.getDeliveryAppoint(), configuration.getSelfMentionSwitch());
        for (OrderCheck orderCheck : orderCheckList) {
            if (orderCheck.support(vo.getOrderType())) {
                orderCheck.check(vo, storeResponse);
                return;
            }
        }
    }
    /***
     * 校验预约单门店数据 优化订单接口冗余方法
     * @param vo
     * @param storeResponse
     * @throws ServiceException 抛出异常校验异常数据
     */
    public static void check(CreateOrderBaseVo vo, StoreResponse storeResponse) throws ServiceException {
        //非预约单的过滤
        if (Objects.isNull(vo.getOrderType()) ||
                (!Objects.equals(vo.getTakeMealFlag(), "1"))) {
            return;
        }
        StoreResponse.Configuration configuration = storeResponse.getBizVO().getStoreConfig();
        if(Objects.isNull(configuration)){
            //针对老数据没有配置 预约单默认支持，直接返回不校验
            return;
        }
        for (OrderCheck orderCheck : orderCheckList) {
            if (orderCheck.support(vo.getOrderType())) {
                orderCheck.check(null, storeResponse);
                return;
            }
        }
    }
}
