/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;


@Data
public class CreateOrderNewVo {

    @NotEmpty(message = "sessionId 不能为空")
    private String sessionId;

    @NotEmpty(message = "门店ID 不能为空")
    private String shopId;

    private String partnerId;
    /**
     * 渠道 1 saas 2 img 爱马哥  默认saas
     */
    private String channel;
    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    @NotNull(message = "下单类型不能为空")
    private Integer orderType;
    /**
     * 取餐时间
     */
    private String takeMealTime;
    /**
     * 是否外带 ,打包  1 是 0 否
     */
    private Integer takeOut;
    /**
     * 订单备注
     */
    private String orderRemark;
    /**
     * 收货地址ID
     */
    private String receiveId;
    /**
     * 券码
     */
    private String couponCode;

    @Valid
    private PremiumExchangeActivity premiumExchangeActivity;

    @Data
    public static class PremiumExchangeActivity {
        @NotNull(message = "activityCode 不能为空")
        private String activityCode;
        @NotNull(message = "activityName 不能为空")
        private String activityName;
        /**
         * 加价购sku商品信息
         */
        @Valid
        private List<Product> products;

        @Data
        public static class Product {
            /**
             * spuId 商品原始id
             */
            @NotNull(message = "spuId不能为空")
            private String spuId;

            /**
             * skuId 如果是多规格 skuId 不能为空
             */
            @NotNull(message = "skuId不能为空")
            private String skuId;
            /**
             * 商品名称
             */
            @NotNull(message = "商品名称不能为空")
            private String skuName;

            @NotNull(message = "商品数量不能为空")
            private Integer qty;

            /**
             * 图片
             */
            private String picture;

            /**
             * 原价 入参不需要传，做对象组装使用
             */
            private Integer originalPrice;
            /**
             * 现价 入参不需要传，做对象组装使用
             */
            private Integer nowPrice;

            @Valid
            private List<Attribute> attributes;

            @Data
            public static class Attribute {
                /**
                 * 属性ID
                 */
                private String attributeId;

                /**
                 * 属性名称
                 */
                private String attributeValue;
            }
        }

    }
}
