package cn.freemud.enums;

public enum CouponStatus {
    STATUS(-1, "未激活"),
    STATUS_0(0, "可用"),
    STATUS_1(1, "已使用"),
    STATUS_2(2, "部分使用"),
    STATUS_3(3, "取消"),
    STATUS_6(6, "已过期"),
    STATUS_99(9, "未知（目前暂不支持）");

    private Integer code;
    private String desc;

    CouponStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponStatus getByCode(Integer code) {
        for (CouponStatus payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
