/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: DefaultShowType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 11:00
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum DefaultShowType {

    CategoryAndFirstProducts(1, " 获取商品分类和第一个分类的所有商品"),
    CategoryAndAllProducts(2, "获取商品分类和所有商品"),
    Category(3, "仅获取商品分类"),
    CategoryAndFirstProductsSort(4, "获取商品分类和第一个分类的所有商品,分页显示");

    private Integer code;

    private String desc;

    DefaultShowType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DefaultShowType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (DefaultShowType type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
