/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单状态
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum PayStatus {

    NOT_PAY(1, "未支付","Unpaid"),
    HAVE_PAID(2, "已支付","Paid"),
    HAVE_REFUND(3, "已退款","Refunded"),
    HAVE_PART_REFUND(4, "已经部分退款","Partial refund"),
    COMPLETE(5, "完成","Complete");


    private Integer code;
    private String desc;
    private String descEn;

    PayStatus(Integer code, String desc,String descEn) {
        this.code = code;
        this.desc = desc;
        this.descEn = descEn;
    }

    public static PayStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (PayStatus payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDescEn() {
        return descEn;
    }

    public void setDescEn(String descEn) {
        this.descEn = descEn;
    }
}
