package cn.freemud.demo.entities.bo.goods.add;

import cn.freemud.demo.entities.bo.goods.McoffeeProductBO;
import cn.freemud.demo.entities.bo.goods.PlatformProductBO;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ComboxGoodsRequestVo;
import cn.freemud.entities.vo.MaterialRequestVo;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

@Data
public class MCoffeeAddGoodsBO extends BaseAddGoodsBO {

    private CartGoods addGoods;

    private String version;

    /**
     * 1.6.0 版本增加  节点ID
     */
    private String nodeId;
    /**
     * 1.6.0 版本增加 分类名
     */
    private String categoryName;
    /**
     * 商品额外的属性
     */
    private List<CartGoods.CartGoodsExtra> extra;
    /**
     * 套餐固定商品
     */
    private List<ComboxGoodsRequestVo> productComboList;
    /**
     * 套餐可选商品
     */
    private List<ComboxGoodsRequestVo> productGroupList;

    /**
     * 加料
     */
    private List<MaterialRequestVo> productMaterialList;

    /**
     * 麦咖啡定制属性
     */
    private List<CartGoods.SpecialExtra> specialExtra;


    private String appType;

    /**
     * 数量
     */
    private Integer qty;


    /**
     * 券类型 0：商品券
     */
    private Integer couponType;

    /**
     * 优惠券号
     */
    private String couponCode;

    /**
     * 套餐名称
     */
    private String groupName;

}
